/*
 * Decompiled with CFR 0.152.
 */
package rene.util;

import java.io.File;

public class FileName {
    public static int ChopLength = 48;

    public static String purefilename(String filename) {
        char[] a2 = filename.toCharArray();
        int i = a2.length - 1;
        char fs = File.separatorChar;
        while (i >= 0) {
            if (a2[i] == fs || a2[i] == '/' || i == 0) {
                if (i == 0) {
                    i = -1;
                }
                if (i < a2.length - 1) {
                    int j = a2.length - 1;
                    while (j > i && a2[j] != '.') {
                        --j;
                    }
                    if (j > i + 1) {
                        return new String(a2, i + 1, j - i - 1);
                    }
                    return "";
                }
                return "";
            }
            --i;
        }
        return filename;
    }

    public static String path(String filename) {
        char[] a2 = filename.toCharArray();
        int i = a2.length - 1;
        char fs = File.separatorChar;
        while (i > 0) {
            if (a2[i] == fs || a2[i] == '/') {
                return new String(a2, 0, i);
            }
            --i;
        }
        return "";
    }

    public static String pathAndSeparator(String filename) {
        char[] a2 = filename.toCharArray();
        int i = a2.length - 1;
        char fs = File.separatorChar;
        while (i > 0) {
            if (a2[i] == fs || a2[i] == '/') {
                return new String(a2, 0, i + 1);
            }
            --i;
        }
        return "";
    }

    public static String filename(String filename) {
        char[] a2 = filename.toCharArray();
        int i = a2.length - 1;
        char fs = File.separatorChar;
        while (i > 0) {
            if (a2[i] == fs || a2[i] == '/') {
                if (i + 1 < a2.length) {
                    return new String(a2, i + 1, a2.length - i - 1);
                }
                return "";
            }
            --i;
        }
        return filename;
    }

    public static String extension(String filename) {
        char[] a2 = filename.toCharArray();
        int i = a2.length - 1;
        char fs = File.separatorChar;
        while (i > 0) {
            if (a2[i] == '.') {
                if (i + 1 < a2.length) {
                    return new String(a2, i + 1, a2.length - i - 1);
                }
                return "";
            }
            if (a2[i] == fs || a2[i] == '/') break;
            --i;
        }
        return "";
    }

    public static String chop(String filename, int chop) {
        if (filename.length() > chop) {
            filename = "... " + filename.substring(filename.length() - chop);
        }
        return filename;
    }

    public static String chop(String filename) {
        return FileName.chop(filename, ChopLength);
    }

    public static String chop(int start, String filename, int chop) {
        if (filename.length() > start + chop) {
            filename = String.valueOf(filename.substring(0, start)) + " ... " + filename.substring(filename.length() - chop);
        }
        return filename;
    }

    public static String chop(int start, String filename) {
        return FileName.chop(start, filename, ChopLength);
    }

    public static String relative(String dir, String filename) {
        if (filename.startsWith(dir = String.valueOf(dir) + System.getProperty("file.separator"))) {
            return filename.substring(dir.length());
        }
        return filename;
    }

    public static String canonical(String filename) {
        File f2 = new File(filename);
        try {
            String s = f2.getCanonicalPath();
            if (s.length() > 2 && s.charAt(1) == ':') {
                s = String.valueOf(s.substring(0, 2).toLowerCase()) + s.substring(2);
            }
            return s;
        }
        catch (Exception e2) {
            return f2.getAbsolutePath();
        }
    }

    public static String toURL(String filename) {
        int n = filename.indexOf(32);
        if (n >= 0) {
            return String.valueOf(filename.substring(0, n)) + "%20" + FileName.toURL(filename.substring(n + 1));
        }
        return filename;
    }

    static boolean match(char[] filename, int n, char[] filter, int m) {
        if (filter == null) {
            return true;
        }
        if (m >= filter.length) {
            return n >= filename.length;
        }
        if (n >= filename.length) {
            return m == filter.length - 1 && filter[m] == '*';
        }
        if (filter[m] == '?') {
            return FileName.match(filename, n + 1, filter, m + 1);
        }
        if (filter[m] == '*') {
            if (m == filter.length - 1) {
                return true;
            }
            int i = n;
            while (i < filename.length) {
                if (FileName.match(filename, i, filter, m + 1)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (filter[m] == filename[n]) {
            return FileName.match(filename, n + 1, filter, m + 1);
        }
        return false;
    }

    public static boolean match(String filename, String filter) {
        char[] fn = filename.toCharArray();
        char[] f2 = filter.toCharArray();
        return FileName.match(fn, 0, f2, 0);
    }

    public static void main(String[] args) {
        System.out.println("-" + FileName.toURL(" test test test ") + "-");
    }
}

