/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;

public class BinderTool
extends ObjectConstructor
implements Selector {
    ObjectConstructor OC;
    PointObject P;
    boolean Control;

    public BinderTool(ZirkelCanvas zc, PointObject p, ObjectConstructor oc) {
        this.P = p;
        this.OC = oc;
        this.P.setSelected(true);
        zc.repaint();
    }

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        this.Control = e2.isControlDown();
        ConstructionObject o = zc.selectWithSelector(e2.getX(), e2.getY(), this);
        if (o == null) {
            return;
        }
        if (this.Control && !(o instanceof InsideObject)) {
            return;
        }
        if (zc.getConstruction().dependsOn(o, this.P)) {
            return;
        }
        this.P.setBound(o.getName());
        if (o instanceof InsideObject) {
            if (this.Control || !(o instanceof PointonObject)) {
                this.P.setInside(true);
            }
        } else {
            this.P.setUseAlpha(!e2.isShiftDown());
        }
        zc.getConstruction().updateCircleDep();
        zc.repaint();
        this.reset(zc);
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        this.Control = e2.isControlDown();
        zc.indicateWithSelector(e2.getX(), e2.getY(), this);
    }

    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        return (o instanceof InsideObject || o instanceof PointonObject) && !zc.getConstruction().dependsOn(o, this.P);
    }

    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Zirkel.name("message.bindpoint"));
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.setTool(this.OC);
        zc.validate();
        zc.repaint();
    }

    public boolean useSmartBoard() {
        return false;
    }
}

