/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import rene.util.MyVector;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;

public class BreakpointAnimator
extends ObjectConstructor
implements Runnable {
    MyVector Breaks = new MyVector();
    ZirkelCanvas ZC;
    boolean Loop = false;
    boolean Running = false;
    boolean Stopped = false;
    long SleepTime = 1024L;

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        double x = zc.x(e2.getX());
        double y = zc.y(e2.getY());
        this.ZC = zc;
        if (this.Running) {
            if (e2.isShiftDown()) {
                this.Loop = !this.Loop;
            } else {
                this.Stopped = true;
                zc.paintUntil(null);
            }
        } else {
            this.reset(zc);
        }
    }

    public synchronized void reset(ZirkelCanvas zc) {
        super.reset(zc);
        this.ZC = zc;
        this.showStatus(zc);
        if (this.Running) {
            this.Stopped = true;
            zc.paintUntil(null);
        } else {
            this.Stopped = false;
            new Thread(this).start();
        }
    }

    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Zirkel.name("message.animatebreak"));
    }

    public void save(XmlWriter xml) {
        xml.startTagStart("AnimateBreakpoints");
        xml.printArg("time", "" + this.SleepTime);
        if (this.Loop) {
            xml.printArg("loop", "true");
        }
        xml.finishTagNewLine();
    }

    public void run() {
        this.ZC.getConstruction().setOriginalOrder(true);
        this.Running = true;
        this.Breaks = new MyVector();
        Enumeration<ConstructionObject> e2 = this.ZC.getConstruction().elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = e2.nextElement();
            if (!o.isBreak()) continue;
            this.Breaks.addElement(o);
        }
        Object[] H = this.Breaks.getArray();
        int N = 0;
        if (this.Breaks.size() == 0) {
            this.Running = false;
            this.ZC.getConstruction().setOriginalOrder(false);
            return;
        }
        ConstructionObject O = (ConstructionObject)H[0];
        boolean forward = true;
        while (!this.Stopped) {
            if (!this.Stopped) {
                this.ZC.paintUntil(O);
            }
            try {
                Thread.sleep(this.SleepTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.Stopped) break;
            if (this.Loop) {
                if (forward) {
                    if (N < this.Breaks.size() - 1) {
                        O = (ConstructionObject)H[++N];
                        continue;
                    }
                    if (N != this.Breaks.size() - 1) continue;
                    ++N;
                    forward = false;
                    O = null;
                    continue;
                }
                if (N > 0) {
                    O = (ConstructionObject)H[--N];
                    continue;
                }
                N = 1;
                O = (ConstructionObject)H[N];
                forward = true;
                continue;
            }
            if (N < this.Breaks.size() - 1) {
                O = (ConstructionObject)H[++N];
                continue;
            }
            if (N == this.Breaks.size() - 1) {
                ++N;
                O = null;
                continue;
            }
            N = 0;
            O = (ConstructionObject)H[N];
        }
        this.Running = false;
        this.ZC.getConstruction().setOriginalOrder(false);
    }

    public synchronized void invalidate(ZirkelCanvas zc) {
        this.Stopped = true;
        this.ZC.paintUntil(null);
    }

    public boolean useSmartBoard() {
        return false;
    }

    public void increaseSpeed() {
        if (this.SleepTime >= 32000L) {
            return;
        }
        this.SleepTime *= 2L;
    }

    public void decreaseSpeed() {
        if (this.SleepTime == 1L) {
            return;
        }
        this.SleepTime /= 2L;
    }

    public void setSpeed(long delay) {
        this.SleepTime = delay;
    }

    public void setLoop(boolean flag) {
        this.Loop = flag;
    }
}

