/*
 * Decompiled with CFR 0.152.
 */
package rene.dialogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import rene.dialogs.ColorEditor;
import rene.gui.MyPanel;

class ColorPanel
extends MyPanel
implements MouseListener,
MouseMotionListener {
    Color C;
    Color OldC;
    Color[] FixedC;
    Color[] UserC;
    int EditUser = -1;
    int W;
    int H;
    int D;
    static double v1;
    static double v2;
    static double v3;
    static double w1;
    static double w2;
    static double w3;
    ColorEditor CE;
    Image I = null;
    Image IH = null;

    static {
        double x = Math.sqrt(2.0);
        v1 = -1.0 / x;
        v2 = 1.0 / x;
        v3 = 0.0;
        x = Math.sqrt(6.0);
        w1 = 1.0 / x;
        w2 = 1.0 / x;
        w3 = -2.0 / x;
    }

    public ColorPanel(Color c2, ColorEditor ce, Color[] fixedc, Color[] userc) {
        this.C = this.OldC = c2;
        this.CE = ce;
        this.FixedC = fixedc;
        this.UserC = userc;
        this.W = 400;
        this.D = 20;
        int k = 0;
        if (this.FixedC != null) {
            k += (this.FixedC.length - 1) / 16 + 1;
        }
        if (this.UserC != null) {
            k += (this.UserC.length - 1) / 16 + 1;
        }
        this.H = 3 * this.D + this.D / 2 + k * (this.D + this.D / 2);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.W, this.H);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setNewColor(Color c2) {
        this.C = c2;
        this.repaint();
    }

    public void setNewColor(double a2, double br, double sat) {
        double c2 = Math.cos(a2);
        double s = Math.sin(a2);
        double x1 = v1 * c2 + w1 * s;
        double x2 = v2 * c2 + w2 * s;
        double x3 = v3 * c2 + w3 * s;
        double max = Math.max(Math.max(x1, x2), x3);
        double min = Math.min(Math.min(x1, x2), x3);
        x1 = -1.0 + 2.0 * (x1 - min) / (max - min);
        x2 = -1.0 + 2.0 * (x2 - min) / (max - min);
        x3 = -1.0 + 2.0 * (x3 - min) / (max - min);
        double f2 = sat * Math.min(1.0 - br, br);
        this.C = new Color((float)(br + x1 * f2), (float)(br + x2 * f2), (float)(br + x3 * f2));
        if (this.EditUser > 0) {
            this.UserC[this.EditUser] = this.C;
        }
        this.repaint();
    }

    public static Color getColor(double a2) {
        double c2 = Math.cos(a2);
        double s = Math.sin(a2);
        double x1 = v1 * c2 + w1 * s;
        double x2 = v2 * c2 + w2 * s;
        double x3 = v3 * c2 + w3 * s;
        double max = Math.max(Math.max(x1, x2), x3);
        double min = Math.min(Math.min(x1, x2), x3);
        x1 = -1.0 + 2.0 * (x1 - min) / (max - min);
        x2 = -1.0 + 2.0 * (x2 - min) / (max - min);
        x3 = -1.0 + 2.0 * (x3 - min) / (max - min);
        return new Color((float)(0.5 + x1 * 0.5), (float)(0.5 + x2 * 0.5), (float)(0.5 + x3 * 0.5));
    }

    public void paint(Graphics g) {
        Color col;
        int i;
        int kc;
        if (this.I == null || this.I.getWidth(this) != this.W || this.I.getHeight(this) != this.H) {
            this.I = this.createImage(this.W, this.H);
        }
        Graphics ig = this.I.getGraphics();
        ig.clearRect(0, 0, this.W, this.H);
        ig.setColor(this.OldC);
        ig.fillRect(this.D / 2, this.D / 2, this.W / 2 - this.D, this.D);
        ig.setColor(this.C);
        ig.fillRect(this.W / 2 + this.D / 2, this.D / 2, this.W / 2 - this.D, this.D);
        if (this.IH == null || this.IH.getWidth(this) != this.W - this.D) {
            this.IH = this.createImage(this.W - this.D, 20);
            Graphics igh = this.IH.getGraphics();
            igh.clearRect(0, 0, this.W - this.D, this.D);
            int i2 = 0;
            while (i2 < this.W - this.D) {
                igh.setColor(ColorPanel.getColor(Math.PI * 2 * (double)i2 / (double)(this.W - this.D)));
                igh.drawLine(i2, 0, i2, this.D - 1);
                ++i2;
            }
        }
        ig.drawImage(this.IH, this.D / 2, 2 * this.D, this);
        int k = this.D / 2 + (int)(ColorPanel.getHue(this.C) * (double)(this.W - this.D));
        ig.setColor(Color.black);
        ig.drawLine(k, 2 * this.D, k, 3 * this.D - 1);
        int yr = 3 * this.D + this.D / 2;
        if (this.FixedC != null) {
            kc = 0;
            i = 0;
            while (i < this.FixedC.length) {
                col = this.FixedC[i];
                if (col == null) {
                    col = Color.gray;
                }
                ig.setColor(this.getBackground());
                ig.fill3DRect(this.D / 2 + kc * (this.D + this.D / 2), yr, this.D, this.D, true);
                ig.setColor(col);
                ig.fillRect(this.D / 2 + kc * (this.D + this.D / 2) + 4, yr + 4, this.D - 8, this.D - 8);
                if (++kc == 16) {
                    kc = 0;
                    yr += this.D + this.D / 2;
                }
                ++i;
            }
            if (kc > 0) {
                yr += this.D + this.D / 2;
            }
        }
        if (this.UserC != null) {
            kc = 0;
            i = 0;
            while (i < this.UserC.length) {
                col = this.UserC[i];
                if (col == null) {
                    col = Color.gray;
                }
                if (this.EditUser == i) {
                    ig.setColor(this.getBackground());
                    ig.fill3DRect(this.D / 2 + kc * (this.D + this.D / 2), yr, this.D, this.D, true);
                    ig.setColor(col);
                    ig.fillRect(this.D / 2 + kc * (this.D + this.D / 2) + 4, yr + 4, this.D - 8, this.D - 8);
                } else {
                    ig.setColor(col);
                    ig.fillRect(this.D / 2 + kc * (this.D + this.D / 2), yr, this.D, this.D);
                }
                if (++kc == 16) {
                    kc = 0;
                    yr += this.D + this.D / 2;
                }
                ++i;
            }
        }
        g.drawImage(this.I, 0, 0, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void mouseDragged(MouseEvent e2) {
        double x = e2.getX();
        double y = e2.getY();
        if (y < (double)(2 * this.D) || y > (double)(3 * this.D) || x <= (double)(this.D / 2) || x >= (double)(this.W - this.D / 2)) {
            return;
        }
        this.C = ColorPanel.getColor(Math.PI * 2 * (x - (double)(this.D / 2)) / (double)(this.W - this.D));
        this.CE.setcolor(this.C);
        if (this.EditUser >= 0) {
            this.UserC[this.EditUser] = this.C;
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent arg0) {
    }

    public static double getSaturation(Color C) {
        double r = (double)C.getRed() / 255.0;
        double g = (double)C.getGreen() / 255.0;
        double b2 = (double)C.getBlue() / 255.0;
        double m = (r + g + b2) / 3.0;
        return Math.sqrt((r - m) * (r - m) + (g - m) * (g - m) + (b2 - m) * (b2 - m)) / Math.sqrt(0.6666666666666666);
    }

    public static double getHue(Color C) {
        double c2;
        double b2;
        double g;
        double m;
        double r = (double)C.getRed() / 255.0;
        double s = (r - (m = (r + (g = (double)C.getGreen() / 255.0) + (b2 = (double)C.getBlue() / 255.0)) / 3.0)) * w1 + (g - m) * w2 + (b2 - m) * w3;
        double a2 = Math.atan2(s, c2 = (r - m) * v1 + (g - m) * v2 + (b2 - m) * v3) / (Math.PI * 2);
        if (a2 < 0.0) {
            a2 += 1.0;
        }
        if (a2 > 1.0) {
            a2 -= 1.0;
        }
        return a2;
    }

    public static double getBrightness(Color C) {
        double r = (double)C.getRed() / 255.0;
        double g = (double)C.getGreen() / 255.0;
        double b2 = (double)C.getBlue() / 255.0;
        return (Math.max(r, Math.max(g, b2)) + Math.min(r, Math.min(g, b2))) / 2.0;
    }

    public Color getColor() {
        return this.C;
    }

    public void mouseClicked(MouseEvent e2) {
        Color col;
        int i;
        int kc;
        int x = e2.getX();
        int y = e2.getY();
        int yr = 3 * this.D + this.D / 2;
        if (this.FixedC != null) {
            kc = 0;
            i = 0;
            while (i < this.FixedC.length) {
                col = this.FixedC[i];
                if (col == null) {
                    col = Color.gray;
                }
                if (y > yr && y < yr + this.D && x > this.D / 2 + kc * (this.D + this.D / 2) && x < this.D / 2 + kc * (this.D + this.D / 2) + this.D) {
                    this.setNewColor(col);
                    this.CE.doAction("OK");
                    this.EditUser = -1;
                    return;
                }
                if (++kc == 16) {
                    kc = 0;
                    yr += this.D + this.D / 2;
                }
                ++i;
            }
            if (kc > 0) {
                yr += this.D + this.D / 2;
            }
        }
        if (this.UserC != null) {
            kc = 0;
            i = 0;
            while (i < this.UserC.length) {
                col = this.UserC[i];
                if (col == null) {
                    col = Color.gray;
                }
                if (y > yr && y < yr + this.D && x > this.D / 2 + kc * (this.D + this.D / 2) && x < this.D / 2 + kc * (this.D + this.D / 2) + this.D) {
                    this.setNewColor(col);
                    if (this.EditUser == i) {
                        this.CE.doAction("OK");
                        this.EditUser = -1;
                    } else {
                        this.EditUser = i;
                        this.repaint();
                    }
                    return;
                }
                if (++kc == 16) {
                    kc = 0;
                    yr += this.D + this.D / 2;
                }
                ++i;
            }
            if (kc > 0) {
                yr += this.D + this.D / 2;
            }
        }
        this.EditUser = -1;
        this.repaint();
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent e2) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public static Color[] getSomeColors() {
        Color[] c2 = new Color[32];
        int i = 0;
        while (i < 32) {
            c2[i] = ColorPanel.getColor(0.19634954084936207 * (double)i);
            ++i;
        }
        return c2;
    }
}

