/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Frame;
import java.util.Enumeration;
import rene.dialogs.Warning;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.dialogs.CircleEditDialog;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.SimulationObject;

public class FixedCircleObject
extends PrimitiveCircleObject
implements MoveableObject,
SimulationObject {
    Expression E;
    boolean EditAborted = false;
    boolean Dragable = false;
    double x1;
    double y1;
    double x2;
    double y2;

    public FixedCircleObject(Construction c2, PointObject p1, double x, double y) {
        super(c2, p1);
        this.init(c2, x, y);
    }

    public void init(Construction c2, double x, double y) {
        this.E = new Expression("" + Math.sqrt((x - this.M.getX()) * (x - this.M.getX()) + (y - this.M.getY()) * (y - this.M.getY())), c2, this);
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Circle";
    }

    public void updateText() {
        if (this.E == null || !this.E.isValid()) {
            return;
        }
        this.setText(FixedCircleObject.text2(Zirkel.name("text.fixedcircle"), this.M.getName(), this.E.toString()));
    }

    public void validate() {
        super.validate();
        if (!this.M.valid()) {
            this.Valid = false;
            return;
        }
        this.Valid = true;
        this.X = this.M.getX();
        this.Y = this.M.getY();
        if (this.E != null && !this.E.isValid()) {
            return;
        }
        try {
            if (this.E != null) {
                this.R = this.E.getValue();
            }
        }
        catch (Exception e2) {
            this.R = 0.0;
            this.Valid = false;
        }
        if (this.R < -1.0E-10) {
            this.Valid = false;
            return;
        }
    }

    public void printArgs(XmlWriter xml) {
        if (this.E.isValid()) {
            xml.printArg("fixed", this.E.toString());
        } else {
            xml.printArg("fixed", "" + this.R);
        }
        if (this.Dragable) {
            xml.printArg("dragable", "true");
        }
        super.printArgs(xml);
    }

    public boolean canFix() {
        return true;
    }

    public boolean fixed() {
        return true;
    }

    public void setFixed(String s) {
        this.E = new Expression(s, this.getConstruction(), this);
    }

    public void round() {
        try {
            this.setFixed(String.valueOf(this.round(this.E.getValue(), ZirkelCanvas.LengthsFactor)));
            this.validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void edit(ZirkelCanvas zc) {
        CircleEditDialog d2;
        while (true) {
            d2 = new CircleEditDialog(zc.getFrame(), this, zc);
            d2.setVisible(true);
            this.EditAborted = false;
            if (d2.isAborted()) {
                this.EditAborted = true;
                break;
            }
            if (this.E.isValid()) break;
            Frame F = zc.getFrame();
            Warning w = new Warning(F, this.E.getErrorText(), Zirkel.name("warning"), true);
            w.center(F);
            w.setVisible(true);
        }
        this.validate();
        this.updateText();
        zc.getConstruction().updateCircleDep();
        zc.repaint();
        if (d2.wantsMore()) {
            new EditConditionals(zc.getFrame(), this);
            this.validate();
        }
    }

    public boolean nearto(int c2, int r, ZirkelCanvas zc) {
        if (!this.Valid && this.M.valid()) {
            return this.M.nearto(c2, r, zc);
        }
        return super.nearto(c2, r, zc);
    }

    public boolean isValidFix() {
        return this.E.isValid();
    }

    public void translate() {
        super.translate();
        try {
            this.setFixed(this.E.toString());
            this.E.translate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getStringLength() {
        return this.E.toString();
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.R;
    }

    public Enumeration depending() {
        super.depending();
        Enumeration e2 = this.E.getDepList().elements();
        while (e2.hasMoreElements()) {
            DL.add((ConstructionObject)e2.nextElement());
        }
        return DL.elements();
    }

    public void move(double x, double y) {
        this.init(this.getConstruction(), x, y);
    }

    public boolean moveable() {
        return this.Dragable || this.M.moveable();
    }

    public boolean isFixed() {
        return true;
    }

    public boolean isEditAborted() {
        return this.EditAborted;
    }

    public boolean isDragable() {
        return this.Dragable;
    }

    public void setDragable(boolean f2) {
        this.Dragable = f2;
    }

    public boolean fixedByNumber() {
        return this.E != null && this.E.isNumber();
    }

    public void setSimulationValue(double x) {
        this.R = x;
        Expression OldE = this.E;
        this.E = null;
        this.validate();
        this.E = OldE;
    }

    public void resetSimulationValue() {
        this.validate();
    }

    public boolean startDrag(double x, double y) {
        this.x1 = this.M.getX();
        this.y1 = this.M.getY();
        this.x2 = x;
        this.y2 = y;
        return true;
    }

    public boolean dragTo(double x, double y) {
        if (this.Dragable) {
            this.move(x, y);
        } else {
            this.M.move(this.x1 + (x - this.x2), this.y1 + (y - this.y2));
        }
        return true;
    }

    public void snap(ZirkelCanvas zc) {
        if (this.moveable() && !this.Dragable) {
            this.M.snap(zc);
        }
    }
}

