/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Frame;
import java.util.Enumeration;
import rene.dialogs.Warning;
import rene.gui.Global;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.AngleEditDialog;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.PointObject;

public class AngleObject
extends ConstructionObject
implements InsideObject {
    protected PointObject P1;
    protected PointObject P2;
    protected PointObject P3;
    static Count N = new Count();
    double A;
    double A1;
    double A2;
    double X;
    double Y;
    boolean Fixed;
    Expression E;
    boolean Filled = false;
    static final double LabelScale = 0.66;
    public static final int NORMALSIZE = 1;
    public static final int SMALL = 0;
    public static final int LARGER = 2;
    public static final int LARGE = 3;
    public static final int RECT = 4;
    protected int DisplaySize = 1;
    double[] x = new double[4];
    double[] y = new double[4];
    public static char[] Translation = new char[]{'a', '\u03b1', 'A', '\u0391', 'b', '\u03b2', 'B', '\u0392', 'c', '\u03b3', 'C', '\u0393', 'd', '\u03b4', 'D', '\u0394', 'e', '\u03b5', 'E', '\u0395', 'f', '\u03d5', 'F', '\u03a6', 'g', '\u03b3', 'G', '\u0393', 'h', '\u03b7', 'H', '\u0397', 'i', '\u03b9', 'I', '\u0399', 'k', '\u03ba', 'K', '\u039a', 'l', '\u03bb', 'L', '\u039b', 'm', '\u03bc', 'M', '\u039c', 'n', '\u03bd', 'N', '\u039d', 'o', '\u03bf', 'O', '\u03a9', 'p', '\u03c0', 'P', '\u03a0', 'q', '\u03c7', 'Q', '\u03a7', 'r', '\u03c1', 'R', '\u03a1', 's', '\u03c3', 'S', '\u03a3', 't', '\u03c4', 'T', '\u03a4', 'u', '\u03c5', 'U', '\u03a5', 'v', '\u03c8', 'V', '\u03a8', 'w', '\u03c9', 'W', '\u03a9', 'x', '\u03be', 'X', '\u039e', 'y', '\u03c7', 'Y', '\u03a7', 'z', '\u03b6', 'Z', '\u0396'};

    public AngleObject(Construction c2, PointObject p1, PointObject p2, PointObject p3) {
        super(c2);
        this.P1 = p1;
        this.P2 = p2;
        this.P3 = p3;
        this.validate();
        this.setColor(this.ColorIndex);
        this.updateText();
        this.Unit = Global.getParameter("unit.angle", "\u00b0");
    }

    public AngleObject(Construction c2) {
        super(c2);
    }

    public String getTag() {
        return "Angle";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        if (!this.Fixed || this.E == null) {
            this.setText(AngleObject.text3(Zirkel.name("text.angle"), this.P1.getName(), this.P2.getName(), this.P3.getName()));
        } else {
            this.setText(AngleObject.text4(Zirkel.name("text.angle.fixed"), this.P1.getName(), this.P2.getName(), this.P3.getName(), "\"" + this.E.toString() + "\""));
        }
    }

    public String getDisplayValue() {
        if (ZirkelCanvas.AnglesFactor <= 2.0) {
            return "" + (int)(this.A / Math.PI * 180.0 + 0.5);
        }
        return "" + this.round(this.A / Math.PI * 180.0, ZirkelCanvas.AnglesFactor);
    }

    public boolean nearto(int x, int y, ZirkelCanvas zc) {
        boolean near;
        if (!this.displays(zc)) {
            return false;
        }
        double dx = zc.x(x) - this.X;
        double dy = zc.y(y) - this.Y;
        double size = zc.dx((int)zc.selectionSize());
        double rd = this.getDisplaySize(zc);
        double r = Math.sqrt(dx * dx + dy * dy);
        this.Value = Math.abs(r - rd);
        if (this.Filled || this.DisplaySize == 4) {
            boolean bl = near = r < rd + size;
            if (near) {
                this.Value = 0.0;
            }
        } else {
            boolean bl = near = Math.abs(r - rd) < size;
        }
        if (!near) {
            return false;
        }
        if (rd < size) {
            return near;
        }
        double a2 = Math.atan2(dy, dx);
        if (a2 < 0.0) {
            a2 += Math.PI * 2;
        }
        double c2 = 0.05;
        if (a2 < this.A1) {
            a2 += Math.PI * 2;
        }
        return a2 > this.A1 - c2 && a2 < this.A1 + this.A + c2;
    }

    public void validate() {
        double dy;
        if (this.P1 == null) {
            return;
        }
        if (!(this.P1.valid() && this.P2.valid() && this.P3.valid())) {
            this.Valid = false;
            return;
        }
        this.X = this.P2.getX();
        this.Y = this.P2.getY();
        double dx = this.P1.getX() - this.X;
        if (Math.sqrt(dx * dx + (dy = this.P1.getY() - this.Y) * dy) < 1.0E-9) {
            this.Valid = false;
            return;
        }
        this.A1 = Math.atan2(dy, dx);
        if (this.A1 < 0.0) {
            this.A1 += Math.PI * 2;
        }
        if (Math.sqrt((dx = this.P3.getX() - this.X) * dx + (dy = this.P3.getY() - this.Y) * dy) < 1.0E-9) {
            this.Valid = false;
            return;
        }
        this.A2 = Math.atan2(dy, dx);
        if (this.A2 < 0.0) {
            this.A2 += Math.PI * 2;
        }
        this.A = this.A2 - this.A1;
        if (this.A < 0.0) {
            this.A += Math.PI * 2;
        }
        this.Valid = true;
        if (this.Fixed) {
            double FixedAlpha = 0.0;
            try {
                FixedAlpha = this.E.getValue() / 180.0 * Math.PI;
            }
            catch (Exception e2) {
                return;
            }
            if (this.P3.moveableBy(this)) {
                dx = this.P3.getX() - this.X;
                double r = Math.sqrt(dx * dx + (dy = this.P3.getY() - this.Y) * dy);
                if (r < 1.0E-9) {
                    r = 1.0E-9;
                }
                this.P3.move(this.X + Math.cos(this.A1 + FixedAlpha) * r, this.Y + Math.sin(this.A1 + FixedAlpha) * r);
                this.A2 = this.A1 + FixedAlpha;
            } else {
                this.Fixed = false;
            }
            if (this.Fixed) {
                this.A = FixedAlpha;
                this.P3.movedBy(this);
                this.P1.movedBy(this);
            }
        } else if (!this.Obtuse && this.A > Math.PI) {
            this.A1 = this.A2;
            this.A = Math.PI * 2 - this.A;
            this.A2 = this.A1 + this.A;
        }
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        String s;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        double R = zc.col(this.getDisplaySize(zc)) - zc.col(0.0);
        double c1 = zc.col(this.X) - R;
        double r1 = zc.row(this.Y) - R;
        double DA = (this.A2 - this.A1) / Math.PI * 180.0;
        if (DA < 0.0) {
            DA += 360.0;
        } else if (DA >= 360.0) {
            DA -= 360.0;
        }
        if (this.visible(zc)) {
            double dy1;
            double dx1;
            if (this.isStrongSelected() && g instanceof MyGraphics13) {
                ((MyGraphics13)g).drawMarkerArc(c1 + R, r1 + R, R, this.A1 / Math.PI * 180.0, DA);
            }
            if (this.Filled) {
                if (this.DisplaySize == 4) {
                    dx1 = Math.cos(this.A1);
                    dy1 = Math.sin(this.A1);
                    double dx2 = Math.cos(this.A1 + DA / 180.0 * Math.PI);
                    double dy2 = Math.sin(this.A1 + DA / 180.0 * Math.PI);
                    double dx3 = dx1 + dx2;
                    double dy3 = dy1 + dy2;
                    if (DA > 180.0) {
                        dx3 = -dx3;
                        dy3 = -dy3;
                    }
                    if (this.Selected || this.getColorType() != 2) {
                        g.setColor(this);
                        g.drawLine(c1 + R + R * dx1, r1 + R - R * dy1, c1 + R + R * dx3, r1 + R - R * dy3);
                        g.drawLine(c1 + R + R * dx3, r1 + R - R * dy3, c1 + R + R * dx2, r1 + R - R * dy2);
                    }
                    this.x[0] = c1 + R;
                    this.y[0] = r1 + R;
                    this.x[1] = c1 + R + R * dx1;
                    this.y[1] = r1 + R - R * dy1;
                    this.x[2] = c1 + R + R * dx3;
                    this.y[2] = r1 + R - R * dy3;
                    this.x[3] = c1 + R + R * dx2;
                    this.y[3] = r1 + R - R * dy2;
                    g.fillPolygon(this.x, this.y, 4, false, this.getColorType() != 1, this);
                } else {
                    g.fillArc(c1, r1, 2.0 * R, 2.0 * R, this.A1 / Math.PI * 180.0, DA, this.Selected || this.getColorType() != 2, this.getColorType() != 1 && !this.isFillBackground(), true, this);
                }
            } else {
                g.setColor(this);
                if (this.DisplaySize == 4) {
                    dx1 = Math.cos(this.A1);
                    dy1 = Math.sin(this.A1);
                    double dx2 = Math.cos(this.A1 + DA / 180.0 * Math.PI);
                    double dy2 = Math.sin(this.A1 + DA / 180.0 * Math.PI);
                    g.drawLine(c1 + R + R * dx1, r1 + R - R * dy1, c1 + R + R * (dx1 + dx2), r1 + R - R * (dy1 + dy2));
                    g.drawLine(c1 + R + R * (dx1 + dx2), r1 + R - R * (dy1 + dy2), c1 + R + R * dx2, r1 + R - R * dy2);
                } else {
                    g.drawCircleArc(c1 + R, r1 + R, R, this.A1 / Math.PI * 180.0, DA, this);
                }
            }
            if (this.Ticks > 0) {
                double dr = zc.scale(Global.getParameter("arrowsize", 10) * 2 / 3);
                g.setColor(this);
                switch (this.Ticks) {
                    case 1: {
                        g.drawLine(c1 + R + Math.cos(this.A1 + this.A / 2.0) * (R - dr), r1 + R - Math.sin(this.A1 + this.A / 2.0) * (R - dr), c1 + R + Math.cos(this.A1 + this.A / 2.0) * (R + dr), r1 + R - Math.sin(this.A1 + this.A / 2.0) * (R + dr));
                        break;
                    }
                    case 2: {
                        double d2 = dr / 200.0;
                        g.drawLine(c1 + R + Math.cos(this.A1 + this.A / 2.0 + d2) * (R - dr), r1 + R - Math.sin(this.A1 + this.A / 2.0 + d2) * (R - dr), c1 + R + Math.cos(this.A1 + this.A / 2.0 + d2) * (R + dr), r1 + R - Math.sin(this.A1 + this.A / 2.0 + d2) * (R + dr));
                        g.drawLine(c1 + R + Math.cos(this.A1 + this.A / 2.0 - d2) * (R - dr), r1 + R - Math.sin(this.A1 + this.A / 2.0 - d2) * (R - dr), c1 + R + Math.cos(this.A1 + this.A / 2.0 - d2) * (R + dr), r1 + R - Math.sin(this.A1 + this.A / 2.0 - d2) * (R + dr));
                        break;
                    }
                    case 3: {
                        double d2 = dr / 100.0;
                        g.drawLine(c1 + R + Math.cos(this.A1 + this.A / 2.0 + d2) * (R - dr), r1 + R - Math.sin(this.A1 + this.A / 2.0 + d2) * (R - dr), c1 + R + Math.cos(this.A1 + this.A / 2.0 + d2) * (R + dr), r1 + R - Math.sin(this.A1 + this.A / 2.0 + d2) * (R + dr));
                        g.drawLine(c1 + R + Math.cos(this.A1 + this.A / 2.0 - d2) * (R - dr), r1 + R - Math.sin(this.A1 + this.A / 2.0 - d2) * (R - dr), c1 + R + Math.cos(this.A1 + this.A / 2.0 - d2) * (R + dr), r1 + R - Math.sin(this.A1 + this.A / 2.0 - d2) * (R + dr));
                        g.drawLine(c1 + R + Math.cos(this.A1 + this.A / 2.0) * (R - dr), r1 + R - Math.sin(this.A1 + this.A / 2.0) * (R - dr), c1 + R + Math.cos(this.A1 + this.A / 2.0) * (R + dr), r1 + R - Math.sin(this.A1 + this.A / 2.0) * (R + dr));
                    }
                }
            }
        }
        if (!(s = AngleObject.translateToUnicode(this.getDisplayText())).equals("")) {
            g.setLabelColor(this);
            this.setFont(g);
            this.DisplaysText = true;
            double dx = Math.cos(this.A1 + this.A / 2.0);
            double dy = Math.sin(this.A1 + this.A / 2.0);
            if (s.equals("90" + this.getUnit()) || this.Name.startsWith(".")) {
                if (this.KeepClose) {
                    double d3 = Math.sqrt(this.XcOffset * this.XcOffset + this.YcOffset * this.YcOffset);
                    this.TX1 = zc.col(this.X + d3 * dx) - 3.0;
                    this.TY1 = zc.row(this.Y + d3 * dy) - 3.0;
                    this.TX2 = this.TX1 + 9.0;
                    this.TY2 = this.TY1 + 9.0;
                    g.drawRect(zc.col(this.X + d3 * dx) - 1.0, zc.row(this.Y + d3 * dy) - 1.0, 3.0, 3.0);
                } else {
                    this.TX1 = zc.col(this.X + zc.dx(R * 0.66) * dx + this.XcOffset) - 3.0;
                    this.TY1 = zc.row(this.Y + zc.dy(R * 0.66) * dy + this.YcOffset) - 3.0;
                    this.TX2 = this.TX1 + 9.0;
                    this.TY2 = this.TY1 + 9.0;
                    g.drawRect(zc.col(this.X + zc.dx(R * 0.66) * dx + this.XcOffset) - 1.0, zc.row(this.Y + zc.dy(R * 0.66) * dy + this.YcOffset) - 1.0, 3.0, 3.0);
                }
            } else if (this.KeepClose) {
                double d4 = Math.sqrt(this.XcOffset * this.XcOffset + this.YcOffset * this.YcOffset);
                this.drawCenteredLabel(g, s, zc, this.X + d4 * dx, this.Y + d4 * dy, 0.0, 0.0);
            } else {
                this.drawCenteredLabel(g, s, zc, this.X + zc.dx(R * 0.66) * dx, this.Y + zc.dy(R * 0.66) * dy, this.XcOffset, this.YcOffset);
            }
        }
    }

    public boolean canKeepClose() {
        return true;
    }

    public void setKeepClose(double x, double y) {
        this.KeepClose = true;
        this.XcOffset = x - this.X;
        this.YcOffset = y - this.Y;
    }

    double getDisplaySize(ZirkelCanvas zc) {
        double R = zc.dx((int)zc.angleSize());
        if (this.DisplaySize == 0 || this.DisplaySize == 4) {
            R /= 2.0;
        } else if (this.DisplaySize == 2) {
            R *= 2.0;
        } else if (this.DisplaySize == 3) {
            double dx = this.P1.getX() - this.X;
            double dy = this.P1.getY() - this.Y;
            R = Math.sqrt(dx * dx + dy * dy);
        }
        return R;
    }

    public double getLength() {
        return this.A;
    }

    public boolean fixed() {
        return this.Fixed;
    }

    public void setFixed(boolean flag) {
        this.Fixed = flag;
        this.updateText();
    }

    public void setFixed(String s) {
        this.Fixed = true;
        this.E = new Expression(s, this.getConstruction(), this);
        this.updateText();
    }

    public boolean canFix() {
        return this.P3.moveableBy(this);
    }

    public void printArgs(XmlWriter xml) {
        if (this.P1 != null) {
            xml.printArg("first", this.P1.getName());
            xml.printArg("root", this.P2.getName());
            xml.printArg("second", this.P3.getName());
        }
        if (this.DisplaySize == 0) {
            xml.printArg("display", "small");
        }
        if (this.DisplaySize == 3) {
            xml.printArg("display", "large");
        }
        if (this.DisplaySize == 2) {
            xml.printArg("display", "larger");
        }
        if (this.DisplaySize == 4) {
            xml.printArg("display", "rectangle");
        }
        if (this.Filled) {
            xml.printArg("filled", "true");
        }
        if (this.Fixed && this.E != null) {
            xml.printArg("fixed", this.E.toString());
        }
        if (!this.Obtuse) {
            xml.printArg("acute", "true");
        }
        super.printArgs(xml);
    }

    public void edit(ZirkelCanvas zc) {
        AngleEditDialog d2 = new AngleEditDialog(zc.getFrame(), this);
        d2.setVisible(true);
        zc.repaint();
        if (this.E != null && !this.E.isValid()) {
            Frame F = zc.getFrame();
            Warning w = new Warning(F, this.E.getErrorText(), Zirkel.name("warning"), true);
            w.center(F);
            w.setVisible(true);
        }
        if (d2.wantsMore()) {
            new EditConditionals(zc.getFrame(), this);
            this.validate();
        }
    }

    public void setDisplaySize(int i) {
        this.DisplaySize = i;
    }

    public int getDisplaySize() {
        return this.DisplaySize;
    }

    public Enumeration depending() {
        super.depending();
        if (this.P1 == null) {
            return DL.elements();
        }
        if (!this.Fixed) {
            return this.depset(this.P1, this.P2, this.P3);
        }
        this.depset(this.P1, this.P2, this.P3);
        Enumeration e2 = this.E.getDepList().elements();
        while (e2.hasMoreElements()) {
            DL.add((ConstructionObject)e2.nextElement());
        }
        return DL.elements();
    }

    public boolean equals(ConstructionObject o) {
        if (!(o instanceof AngleObject) || !o.valid()) {
            return false;
        }
        AngleObject l = (AngleObject)o;
        return this.equals(this.X, l.X) && this.equals(this.Y, l.Y) && this.equals(this.A1, l.A1) && this.equals(this.A2, l.A2);
    }

    public static String translateToUnicode(String s) {
        if (s.startsWith("$")) {
            return s;
        }
        if (s.indexOf(92) < 0) {
            return s;
        }
        StringBuffer b2 = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c2 = s.charAt(i);
            if (c2 != '\\') {
                b2.append(c2);
            } else if (++i < s.length()) {
                c2 = s.charAt(i);
                if (c2 == '0') {
                    int n = 0;
                    ++i;
                    while (i < s.length()) {
                        char ch = s.charAt(i);
                        if (ch >= '0' && ch <= '9') {
                            n = n * 16 + (ch - 48);
                        } else {
                            if (ch < 'A' || ch > 'F') break;
                            n = n * 16 + (ch - 65 + 10);
                        }
                        ++i;
                    }
                    if (n > 0) {
                        c2 = (char)n;
                        b2.append(c2);
                    }
                    --i;
                } else {
                    int j = 0;
                    j = 0;
                    while (j < Translation.length) {
                        if (Translation[j] == c2) {
                            b2.append(Translation[j + 1]);
                            break;
                        }
                        j += 2;
                    }
                    if (j >= Translation.length) {
                        b2.append(c2);
                    }
                }
            }
            ++i;
        }
        return b2.toString();
    }

    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
        this.P2 = (PointObject)this.P2.getTranslation();
        this.P3 = (PointObject)this.P3.getTranslation();
        if (this.Fixed) {
            try {
                this.setFixed(this.E.toString());
                this.E.translate();
            }
            catch (Exception e2) {
                this.Fixed = false;
            }
        }
    }

    public String getE() {
        if (this.Fixed && this.E != null) {
            return this.E.toString();
        }
        return "" + this.round(this.A / Math.PI * 180.0);
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.A / Math.PI * 180.0;
    }

    public void setFilled(boolean flag) {
        this.Filled = flag;
    }

    public boolean isFilled() {
        return this.Filled;
    }

    public boolean maybeTransparent() {
        return true;
    }

    public boolean isFilledForSelect() {
        return false;
    }

    public double containsInside(PointObject P) {
        double dx = P.getX() - this.X;
        double dy = P.getY() - this.Y;
        double a2 = Math.atan2(dy, dx);
        if (a2 < 0.0) {
            a2 += Math.PI * 2;
        }
        if (a2 < this.A1) {
            a2 += Math.PI * 2;
        }
        double c2 = 1.0E-5;
        if (a2 > this.A1 && a2 < this.A1 + this.A) {
            return 1.0;
        }
        if (a2 > this.A1 - c2 && a2 < this.A1 + this.A + c2) {
            return 0.5;
        }
        return 0.0;
    }

    public boolean keepInside(PointObject P) {
        double yh;
        double xh;
        double dist;
        double y2;
        double dy;
        double r;
        if (this.containsInside(P) > 0.0) {
            return true;
        }
        double x = P.getX();
        double y = P.getY();
        double x1 = this.P2.getX();
        double y1 = this.P2.getY();
        double xmin = x1;
        double ymin = y1;
        double dmin = 1.0E20;
        double x2 = this.P1.getX();
        double dx = x2 - x1;
        double h = dx * (x - x1) / (r = dx * dx + (dy = (y2 = this.P1.getY()) - y1) * dy) + dy * (y - y1) / r;
        if (h < 0.0) {
            h = 0.0;
        }
        if ((dist = Math.sqrt((x - (xh = x1 + h * dx)) * (x - xh) + (y - (yh = y1 + h * dy)) * (y - yh))) < dmin) {
            dmin = dist;
            xmin = xh;
            ymin = yh;
        }
        if ((h = (dx = (x2 = this.P3.getX()) - x1) * (x - x1) / (r = dx * dx + (dy = (y2 = this.P3.getY()) - y1) * dy) + dy * (y - y1) / r) < 0.0) {
            h = 0.0;
        }
        if ((dist = Math.sqrt((x - (xh = x1 + h * dx)) * (x - xh) + (y - (yh = y1 + h * dy)) * (y - yh))) < dmin) {
            dmin = dist;
            xmin = xh;
            ymin = yh;
        }
        P.move(xmin, ymin);
        return false;
    }

    public boolean canHaveTicks() {
        return true;
    }
}

