/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.ConstructionObject;

public class PolygonFiller {
    MyGraphics G;
    ConstructionObject O;
    double C;
    double R;
    double C1;
    double R1;
    boolean HaveToFinish;
    public static int step = 5;
    public boolean Started;
    boolean Solid;
    double[] x;
    double[] y;
    int nx;

    public PolygonFiller(MyGraphics g, ConstructionObject o) {
        this.G = g;
        this.O = o;
        this.Started = false;
    }

    public void startPolygon(double c2, double r) {
        this.C = c2;
        this.R = r;
        this.HaveToFinish = false;
        this.nx = 0;
        this.Started = true;
        this.drawTo(c2, r, false);
    }

    public void start() {
        this.nx = 0;
        this.Started = false;
    }

    public void drawTo(double c2, double r) {
        this.drawTo(c2, r, true);
    }

    public void drawTo(double c2, double r, boolean optimized) {
        if (!this.Started) {
            this.startPolygon(c2, r);
            return;
        }
        if (!optimized || (c2 - this.C) * (c2 - this.C) + (r - this.R) * (r - this.R) > (double)step) {
            if (this.x == null) {
                this.x = new double[1000];
                this.y = new double[1000];
                this.nx = 0;
            }
            if (this.nx >= this.x.length) {
                double[] xn = new double[2 * this.x.length];
                double[] yn = new double[2 * this.x.length];
                int i = 0;
                while (i < this.nx) {
                    xn[i] = this.x[i];
                    yn[i] = this.y[i];
                    ++i;
                }
                this.x = xn;
                this.y = yn;
            }
            this.x[this.nx] = c2;
            this.y[this.nx++] = r;
            this.C = c2;
            this.R = r;
            this.HaveToFinish = false;
        } else {
            this.C1 = c2;
            this.R1 = r;
            this.HaveToFinish = true;
        }
    }

    public void finishPolygon() {
        if (this.HaveToFinish) {
            this.drawTo(this.C1, this.R1, false);
            this.HaveToFinish = false;
        }
        this.G.fillPolygon(this.x, this.y, this.nx, false, true, this.O);
        this.Started = false;
    }

    public int length() {
        return this.nx;
    }

    public double x(int i) {
        return this.x[i];
    }

    public double y(int i) {
        return this.y[i];
    }

    public void setGraphics(MyGraphics g) {
        this.G = g;
    }
}

