/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import rene.dialogs.ColorEditor;
import rene.gui.ButtonAction;
import rene.gui.Global;
import rene.gui.IconBar;
import rene.gui.IconBarListener;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.MyTextField;
import rene.gui.Panel3D;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.dialogs.HelpCloseDialog;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointonObject;

public class ObjectEditDialog
extends HelpCloseDialog
implements IconBarListener {
    protected MyTextField Text;
    protected MyTextField Unit;
    protected MyTextField Equation;
    protected TextFieldAction Name;
    protected TextFieldAction Alias;
    protected ConstructionObject O;
    protected IconBar ColorIB;
    protected IconBar ThicknessIB;
    protected IconBar IB;
    protected Frame F;
    protected boolean More;
    protected ButtonAction OK;
    protected boolean SuperHide = false;
    protected boolean HideChanged = false;
    protected boolean HidingBreak = false;
    protected boolean BreakChanged = false;
    protected boolean OKControlDown = false;
    Checkbox Decorative;
    public static Color[] UserC = null;

    static {
        ObjectEditDialog.getUserC();
    }

    public ObjectEditDialog(Frame f2, String title, ConstructionObject o) {
        this(f2, title, o, "properties");
    }

    public ObjectEditDialog(Frame f2, String title, ConstructionObject o, String subject) {
        super(f2, title, true);
        String eq;
        this.F = f2;
        this.O = o;
        o.getConstruction().changed(true);
        this.setLayout(new BorderLayout());
        MyPanel center = new MyPanel();
        center.setLayout(new BorderLayout());
        MyPanel P = new MyPanel();
        this.Name = new TextFieldAction(this, "Name", o.getName(), 32);
        if (this.O.canDisplayName()) {
            this.Alias = new TextFieldAction(this, "Alias", o.getAlias(), 32);
        }
        this.Text = new MyTextField(o.getText(), 32);
        this.Unit = new MyTextField(o.getUnit(), 32);
        P.setLayout(new GridLayout(0, 2));
        P.add(new MyLabel(Zirkel.name("edit.name")));
        P.add(this.Name);
        if (this.Alias != null) {
            P.add(new MyLabel(Zirkel.name("edit.alias")));
            P.add(this.Alias);
        }
        P.add(new MyLabel(Zirkel.name("edit.text")));
        P.add(this.Text);
        if (o.hasUnit()) {
            P.add(new MyLabel(Zirkel.name("edit.unit")));
            P.add(this.Unit);
        }
        if (!(eq = o.getEquation()).equals("")) {
            P.add(new MyLabel(Zirkel.name("edit.equation")));
            this.Equation = new MyTextField(o.getName(), 32);
            this.Equation.setEditable(false);
            this.Equation.setText(eq);
            P.add(this.Equation);
        }
        if (o instanceof PointonObject) {
            P.add(new MyLabel(Zirkel.name("edit.decorative")));
            this.Decorative = new Checkbox("");
            this.Decorative.setState(o.isDecorative());
            P.add(this.Decorative);
        }
        this.addFirst(P);
        center.add("Center", P);
        MyPanel cs = new MyPanel();
        cs.setLayout(new GridLayout(0, 2));
        this.ColorIB = new IconBar(this);
        this.ColorIB.setIconBarListener(this);
        this.ColorIB.addToggleGroupLeft("color", 6);
        this.ColorIB.toggle("color", this.O.getColorIndex(true));
        this.ColorIB.addSeparatorLeft();
        this.ColorIB.addColoredIconLeft("colors", o.getNormalColor());
        if (o.hasUserColor()) {
            this.ColorIB.unselect("color0");
            this.ColorIB.set("colors", true);
        }
        cs.add(new MyLabel(""));
        cs.add(this.ColorIB);
        this.ThicknessIB = new IconBar(this);
        this.ThicknessIB.addToggleGroupLeft("thickness", 4);
        int ct = this.O.getColorType(true);
        this.ThicknessIB.toggle("thickness", ct);
        boolean tsep = false;
        if (this.O.canFillBackground()) {
            this.ThicknessIB.addSeparatorLeft();
            tsep = true;
            this.ThicknessIB.addToggleLeft("fillbackground");
            this.ThicknessIB.setState("fillbackground", this.O.isFillBackground());
        }
        if (o.maybeTransparent()) {
            if (!tsep) {
                this.ThicknessIB.addSeparatorLeft();
            }
            tsep = true;
            this.ThicknessIB.addOnOffLeft("solid");
            this.ThicknessIB.setState("solid", o.isSolid(true));
            if (!o.isFilled()) {
                this.ThicknessIB.setEnabled("solid", false);
            }
        }
        if (o.canHaveTicks()) {
            if (!tsep) {
                this.ThicknessIB.addSeparatorLeft();
            }
            tsep = true;
            this.ThicknessIB.addMultipleIconLeft("mark", 4);
            this.ThicknessIB.setMultipleState("mark", o.getTicks());
        }
        cs.add(new MyLabel(""));
        cs.add(this.ThicknessIB);
        this.IB = new IconBar(f2);
        this.IB.setIconBarListener(this);
        this.IB.addOnOffLeft("hide");
        this.IB.setState("hide", this.O.isHidden(true));
        this.IB.addSeparatorLeft();
        if (this.O.canDisplayName()) {
            this.IB.addOnOffLeft("showname");
            this.IB.setState("showname", this.O.showName(true));
            if (this.showsValue()) {
                this.IB.addOnOffLeft("showvalue");
                this.IB.setState("showvalue", this.O.showValue(true));
            }
            this.IB.addSeparatorLeft();
            this.IB.addOnOffLeft("bold");
            this.IB.setState("bold", this.O.isBold());
            this.IB.addOnOffLeft("large");
            this.IB.setState("large", this.O.isLarge());
            this.IB.addSeparatorLeft();
        }
        this.IB.addOnOffLeft("isback");
        this.IB.setState("isback", this.O.isBack(true));
        this.IB.addOnOffLeft("setbreak");
        this.IB.setState("setbreak", this.O.isBreak());
        cs.add(new MyLabel(""));
        cs.add(this.IB);
        this.addSecond(cs);
        center.add("South", cs);
        this.add("Center", new Panel3D(center));
        MyPanel p = new MyPanel();
        this.addButton(p);
        if (Global.getParameter("options.more", true)) {
            p.add(new ButtonAction(this, Zirkel.name("edit.more"), "More"));
        }
        this.OK = new ButtonAction(this, Zirkel.name("edit.ok"), "OK");
        p.add(this.OK);
        this.OK.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                ObjectEditDialog.this.OKControlDown = e2.isControlDown();
            }
        });
        this.OKControlDown = false;
        ButtonAction b2 = new ButtonAction(this, Zirkel.name("edit.cancel"), "Close");
        p.add(b2);
        this.addHelp(p, subject);
        this.add("South", new Panel3D(p));
        this.More = false;
        this.pack();
        this.center(f2);
    }

    public void doAction(String o) {
        if (o.equals("OK") || o.equals("Name") || o.equals("Alias") || o.equals("More")) {
            int cs;
            String text;
            this.More = o.equals("More") || this.OKControlDown;
            this.O.setName(this.Name.getText());
            if (this.Alias != null) {
                if (!this.Alias.getText().equals("")) {
                    if (this.O.getAlias() == null || !this.O.getAlias().equals(this.Alias.getText())) {
                        this.O.setShowName(true);
                    }
                    this.O.setAlias(this.Alias.getText());
                } else {
                    this.O.setAlias(null);
                }
            }
            if (o.equals("Name")) {
                this.IB.setState("showname", true);
            }
            if ((text = this.Text.getText()).equals("")) {
                this.O.setText("", true);
                this.O.updateText();
            } else if (!this.O.getText().equals(text)) {
                if (!text.endsWith(" ")) {
                    text = String.valueOf(text) + " ";
                }
                this.O.setText(text, true);
            }
            this.O.setUnit(this.Unit.getText());
            if (this.HideChanged) {
                this.O.setHidden(this.IB.getState("hide"));
                if (this.SuperHide && this.IB.getState("hide")) {
                    this.O.setSuperHidden(true);
                } else {
                    this.O.setSuperHidden(false);
                }
            }
            if ((cs = this.ColorIB.getToggleState("color")) >= 0) {
                this.O.setColor(this.ColorIB.getToggleState("color"));
            } else {
                this.O.setColor(this.ColorIB.getColoredIcon("colors"));
            }
            this.O.setColorType(this.ThicknessIB.getToggleState("thickness"));
            if (this.O.canFillBackground()) {
                this.O.setFillBackground(this.ThicknessIB.getState("fillbackground"));
            }
            this.O.setShowName(o.equals("Name") || o.equals("Alias") || this.IB.getState("showname"));
            this.O.setBold(this.IB.getState("bold"));
            this.O.setLarge(this.IB.getState("large"));
            this.O.setBack(this.IB.getState("isback"));
            if (this.showsValue()) {
                this.O.setShowValue(this.IB.getState("showvalue"));
            }
            if (this.O.maybeTransparent()) {
                this.O.setSolid(this.ThicknessIB.getState("solid"));
            }
            if (this.BreakChanged) {
                if (this.IB.getState("setbreak")) {
                    if (this.HidingBreak) {
                        this.O.setHideBreak(true);
                    } else {
                        this.O.setBreak(true);
                    }
                } else {
                    this.O.setBreak(false);
                }
            }
            if (this.O instanceof PointonObject && this.Decorative != null) {
                this.O.setDecorative(this.Decorative.getState());
            }
            if (this.O.canHaveTicks()) {
                this.O.setTicks(this.ThicknessIB.getMultipleState("mark"));
            }
            this.doclose();
            this.setAction();
        } else {
            super.doAction(o);
        }
    }

    public void addFirst(Panel P) {
    }

    public void addSecond(Panel P) {
    }

    public void addButton(Panel p) {
    }

    public void setAction() {
    }

    public static void rememberUserC() {
        int i = 0;
        while (i < UserC.length) {
            Global.setParameter("usercolor" + i, UserC[i]);
            ++i;
        }
    }

    public static void getUserC() {
        UserC = ColorEditor.getSomeColors();
        int i = 0;
        while (i < UserC.length) {
            Color c2;
            ObjectEditDialog.UserC[i] = c2 = Global.getParameter("usercolor" + i, UserC[i]);
            ++i;
        }
    }

    public void iconPressed(String o) {
        if (o.equals("hide")) {
            this.HideChanged = true;
            this.SuperHide = this.IB.isShiftPressed() ? this.IB.getState("hide") : false;
        } else if (o.equals("setbreak")) {
            this.BreakChanged = true;
            this.HidingBreak = this.IB.isShiftPressed() ? this.IB.getState("setbreak") : false;
        } else if (o.equals("colors")) {
            ColorEditor ce = new ColorEditor(this.F, "colors.recent", this.O.getColor(), ZirkelFrame.Colors, UserC);
            ce.center(this.F);
            ce.setVisible(true);
            if (!ce.isAborted()) {
                this.ColorIB.setColoredIcon("colors", ce.getColor());
                Global.setParameter("colors.recent", ce.getColor());
                this.ColorIB.unselect("color0");
                this.ColorIB.set("colors", true);
                ObjectEditDialog.rememberUserC();
            }
        } else if (o.startsWith("color")) {
            this.ColorIB.set("colors", false);
        }
    }

    public void showValue() {
        if (this.showsValue()) {
            this.IB.setState("showvalue", true);
        }
    }

    public boolean showsValue() {
        return true;
    }

    public boolean wantsMore() {
        return this.More;
    }
}

