/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.PrintWriter;
import rene.gui.Global;
import rene.util.xml.SVGWriter;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.SvgFontMetrics;
import rene.zirkel.objects.ConstructionObject;

public class MyGraphicsSvg
extends MyGraphics {
    int W;
    int H;
    PrintWriter Out;
    static final int STROKE_NORMAL = 0;
    static final int STROKE_THIN = 1;
    static final int STROKE_THICK = 2;
    static final int STYLE_NORMAL = 0;
    static final int STYLE_THIN = 1;
    static final int STYLE_THICK = 0;
    int Stroke = 0;
    Color col;
    Color fillcol;
    SvgFontMetrics MFM = new SvgFontMetrics();
    int yoffset = 6000;
    int FontH = 12;
    SVGWriter svg;
    int fsize;
    boolean flarge;
    boolean fbold;
    int ffactor = Global.getParameter("ffactor", 130);

    public MyGraphicsSvg(PrintWriter out, int w, int h) {
        this.svg = new SVGWriter(out);
        this.svg.startSVG(w, h);
        this.W = w;
        this.H = h;
    }

    public void close() {
        this.svg.endTagNewLine("svg");
    }

    public void setColor(Color c2) {
        this.col = c2;
    }

    public void setFillcolor(Color c2) {
        this.fillcol = c2;
    }

    public void setColor(ConstructionObject o) {
        if (o.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (o.selected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else {
            if (o.getColorType() == 2) {
                int i = o.getColorIndex();
                if (o.isHidden()) {
                    this.setColor(ZirkelFrame.BrighterLightColors[i]);
                } else {
                    this.setColor(ZirkelFrame.LightColors[i]);
                }
            } else {
                int i = o.getColorIndex();
                if (o.isHidden()) {
                    this.setColor(ZirkelFrame.BrighterColors[i]);
                } else {
                    this.setColor(ZirkelFrame.Colors[i]);
                }
            }
            this.Stroke = o.getColorType() == 2 ? 1 : (o.getColorType() == 1 ? 2 : 0);
        }
    }

    public void setFillColor(ConstructionObject o) {
        if (o.isJobTarget()) {
            this.setFillcolor(ZirkelFrame.TargetColor);
        } else if (o.getColorType() == 0 && o.isFillBackground()) {
            this.fillcol = Color.white;
        } else if (o.getColorType() != 1) {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setFillcolor(ZirkelFrame.BrighterLightColors[i]);
            } else {
                this.setFillcolor(ZirkelFrame.LightColors[i]);
            }
        } else {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setFillcolor(ZirkelFrame.BrighterColors[i]);
            } else {
                this.setFillcolor(ZirkelFrame.Colors[i]);
            }
        }
    }

    public void setLabelColor(ConstructionObject o) {
        if (o.labelSelected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (o.isFilled()) {
            int type = o.getColorType();
            o.setColorType(0);
            this.setColor(o);
            o.setColorType(type);
        } else {
            this.setColor(o);
        }
    }

    public void clearRect(int x, int y, int w, int h, Color c2) {
    }

    public void drawRect(double x, double y, double w, double h) {
        this.svg.startTagStart("path");
        this.svg.printArg("d", "M " + x + " " + y + " H " + (x + (w -= 1.0)) + " V " + (y + (h -= 1.0)) + " H " + x + " Z");
        this.svg.printArg("style", "fill:none;stroke:" + this.rgb() + ";stroke-width:1");
        this.svg.finishTagNewLine();
    }

    public String rgb() {
        return "rgb(" + this.col.getRed() + "," + this.col.getGreen() + "," + this.col.getBlue() + ")";
    }

    public String frgb() {
        return "rgb(" + this.fillcol.getRed() + "," + this.fillcol.getGreen() + "," + this.fillcol.getBlue() + ")";
    }

    public void drawLine(double x, double y, double x1, double y1) {
        this.svg.startTagStart("line");
        this.svg.printArg("x1", "" + x);
        this.svg.printArg("y1", "" + y);
        this.svg.printArg("x2", "" + x1);
        this.svg.printArg("y2", "" + y1);
        switch (this.Stroke) {
            case 0: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1");
                break;
            }
            case 2: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:3");
                break;
            }
            case 1: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1;fill:none;stroke-dasharray:5,5");
            }
        }
        this.svg.finishTagNewLine();
    }

    public void drawThickLine(double x, double y, double x1, double y1) {
        this.svg.startTagStart("line");
        this.svg.printArg("x1", "" + x);
        this.svg.printArg("y1", "" + y);
        this.svg.printArg("x2", "" + x1);
        this.svg.printArg("y2", "" + y1);
        this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:3");
        this.svg.finishTagNewLine();
    }

    public void drawLine(double x, double y, double x1, double y1, ConstructionObject o) {
        this.svg.startTagStart("line");
        this.svg.printArg("x1", "" + x);
        this.svg.printArg("y1", "" + y);
        this.svg.printArg("x2", "" + x1);
        this.svg.printArg("y2", "" + y1);
        this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1");
        this.svg.finishTagNewLine();
    }

    public void drawArc(double x, double y, double w, double h, double a2, double b2) {
        double x0 = Math.round(x + w / 2.0 + w * Math.cos(a2 / 180.0 * Math.PI) / 2.0);
        double y0 = Math.round(y + h / 2.0 - h * Math.sin(a2 / 180.0 * Math.PI) / 2.0);
        double x1 = Math.round(x + w / 2.0 + w * Math.cos((a2 + b2) / 180.0 * Math.PI) / 2.0);
        double y1 = Math.round(y + h / 2.0 - h * Math.sin((a2 + b2) / 180.0 * Math.PI) / 2.0);
        int f2 = 0;
        if (b2 > 180.0) {
            f2 = 1;
        }
        this.svg.startTagStart("path");
        this.svg.printArg("d", "M " + x0 + " " + y0 + " A " + w / 2.0 + " " + h / 2.0 + " 0 " + f2 + " 0 " + x1 + " " + y1);
        this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1;fill:none");
        this.svg.finishTagNewLine();
    }

    public void drawArc(double x, double y, double w, double h, double a2, double b2, ConstructionObject o) {
        double x0 = Math.round((x += (w /= 2.0)) + w * Math.cos(a2 / 180.0 * Math.PI));
        double y0 = Math.round((y += (h /= 2.0)) - h * Math.sin(a2 / 180.0 * Math.PI));
        double x1 = Math.round(x + w * Math.cos((a2 + b2) / 180.0 * Math.PI));
        double y1 = Math.round(y - h * Math.sin((a2 + b2) / 180.0 * Math.PI));
        int f2 = 0;
        if (b2 > 180.0) {
            f2 = 1;
        }
        this.svg.startTagStart("path");
        this.svg.printArg("d", "M " + x0 + " " + y0 + " A " + w + " " + h + " 0 " + f2 + " 0 " + x1 + " " + y1);
        switch (this.Stroke) {
            case 0: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1;fill:none");
                break;
            }
            case 2: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:3;fill:none");
                break;
            }
            case 1: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1;fill:none;stroke-dasharray:5,5");
            }
        }
        this.svg.finishTagNewLine();
    }

    public FontMetrics getFontMetrics() {
        return this.MFM;
    }

    public void drawString(String s, double x, double y) {
        this.svg.startTagStart("text");
        this.svg.printArg("x", "" + x);
        this.svg.printArg("y", "" + (y + 10.0));
        this.svg.printArg("style", "font-size:" + this.FontH + ";fill:" + this.rgb() + ";font-weight:" + (Global.getParameter("font.bold", false) ? "gold" : "normal"));
        this.svg.startTagEnd();
        this.svg.print(s);
        this.svg.endTagNewLine("text");
    }

    public void drawOval(double x, double y, double w, double h) {
        this.svg.startTagStart("ellipse");
        this.svg.printArg("cx", "" + (x += (w /= 2.0)));
        this.svg.printArg("cy", "" + (y += (h /= 2.0)));
        this.svg.printArg("rx", "" + w);
        this.svg.printArg("ry", "" + h);
        this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1;fill:none");
        this.svg.finishTagNewLine();
    }

    public void drawOval(double x, double y, double w, double h, ConstructionObject o) {
        this.svg.startTagStart("ellipse");
        this.svg.printArg("cx", "" + (x += (w /= 2.0)));
        this.svg.printArg("cy", "" + (y += (h /= 2.0)));
        this.svg.printArg("rx", "" + w);
        this.svg.printArg("ry", "" + h);
        switch (this.Stroke) {
            case 0: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";fill:none;stroke-width:1");
                break;
            }
            case 2: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";fill:none;stroke-width:3");
                break;
            }
            case 1: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1;fill:none;stroke-dasharray:5,5");
            }
        }
        this.svg.finishTagNewLine();
    }

    public void fillRect(double x, double y, double w, double h, boolean outline, boolean transparent, ConstructionObject o) {
        this.svg.startTagStart("path");
        this.svg.printArg("d", "M " + x + " " + y + " H " + (x + (w -= 1.0)) + " V " + (y + (h -= 1.0)) + " H " + x + " Z");
        this.svg.printArg("style", "fill:" + this.rgb() + ";stroke:" + this.rgb() + ";stroke-width:1");
        this.svg.finishTagNewLine();
    }

    public void fillArc(double x, double y, double w, double h, double a2, double b2, boolean outline, boolean transparent, boolean arc, ConstructionObject o) {
        this.setFillColor(o);
        int x0 = (int)Math.round(x + w / 2.0 + w * Math.cos(a2 / 180.0 * Math.PI) / 2.0);
        int y0 = (int)Math.round(y + h / 2.0 - h * Math.sin(a2 / 180.0 * Math.PI) / 2.0);
        int x1 = (int)Math.round(x + w / 2.0 + w * Math.cos((a2 + b2) / 180.0 * Math.PI) / 2.0);
        int y1 = (int)Math.round(y + h / 2.0 - h * Math.sin((a2 + b2) / 180.0 * Math.PI) / 2.0);
        int f2 = 0;
        if (b2 > 180.0) {
            f2 = 1;
        }
        this.svg.startTagStart("path");
        if (arc) {
            this.svg.printArg("d", "M " + (x + w / 2.0) + " " + (y + h / 2.0) + " L " + x0 + " " + y0 + " A " + w / 2.0 + " " + h / 2.0 + " 0 " + f2 + " 0 " + x1 + " " + y1 + " L " + (x + w / 2.0) + " " + (y + h / 2.0));
        } else {
            this.svg.printArg("d", "M " + x0 + " " + y0 + " A " + w / 2.0 + " " + h / 2.0 + " 0 " + f2 + " 0 " + x1 + " " + y1 + " L " + x0 + " " + y0);
        }
        switch (this.Stroke) {
            case 0: {
                this.svg.printArg("style", "fill:" + this.frgb() + (transparent && !o.isSolid() ? ";fill-opacity:0.5" : ""));
                break;
            }
            case 2: {
                this.svg.printArg("style", "fill:" + this.frgb());
                break;
            }
            case 1: {
                this.svg.printArg("style", "fill:" + this.frgb() + (transparent && !o.isSolid() ? ";fill-opacity:0.5" : ""));
            }
        }
        this.svg.finishTagNewLine();
        if (outline) {
            this.setColor(o);
            this.drawArc(x, y, w, h, a2, b2);
        }
    }

    public void fillOval(double x, double y, double w, double h, boolean outline, boolean transparent, ConstructionObject o) {
        this.setFillColor(o);
        this.svg.startTagStart("ellipse");
        this.svg.printArg("cx", "" + (x + w / 2.0));
        this.svg.printArg("cy", "" + (y + h / 2.0));
        this.svg.printArg("rx", "" + w / 2.0);
        this.svg.printArg("ry", "" + h / 2.0);
        switch (this.Stroke) {
            case 0: {
                this.svg.printArg("style", "fill:" + this.frgb() + (transparent && !o.isSolid() ? ";fill-opacity:0.5" : ""));
                break;
            }
            case 2: {
                this.svg.printArg("style", "fill:" + this.frgb());
                break;
            }
            case 1: {
                this.svg.printArg("style", "fill:" + this.frgb() + (transparent && !o.isSolid() ? ";fill-opacity:0.5" : ""));
            }
        }
        this.svg.finishTagNewLine();
        if (outline) {
            this.setColor(o);
            this.drawOval(x, y, w, h);
        }
    }

    public void fillPolygon(double[] x, double[] y, int n, boolean outline, boolean transparent, ConstructionObject o) {
        this.setFillColor(o);
        this.svg.startTagStart("path");
        String s = "M " + x[0] + " " + y[0];
        int i = 1;
        while (i < n) {
            s = String.valueOf(s) + " L " + x[i] + " " + y[i];
            ++i;
        }
        s = String.valueOf(s) + " L " + x[0] + " " + y[0];
        this.svg.printArg("d", s);
        switch (this.Stroke) {
            case 0: {
                this.svg.printArg("style", "fill:" + this.frgb() + (transparent && !o.isSolid() ? ";fill-opacity:0.5" : ""));
                break;
            }
            case 2: {
                this.svg.printArg("style", "fill:" + this.frgb());
                break;
            }
            case 1: {
                this.svg.printArg("style", "fill:" + this.frgb() + (transparent && !o.isSolid() ? ";fill-opacity:0.5" : ""));
            }
        }
        this.svg.finishTagNewLine();
        if (outline) {
            this.svg.startTagStart("path");
            this.svg.printArg("d", s);
            this.setColor(o);
            this.svg.printArg("style", "fill:none;stroke:" + this.rgb() + ";stroke-width:1");
            this.svg.finishTagNewLine();
        }
    }

    public void drawImage(Image i, int x, int y, ImageObserver o) {
    }

    public void drawImage(Image i, int x, int y, int w, int h, ImageObserver o) {
    }

    public void setFont(int h, boolean bold) {
        this.FontH = h;
    }

    public void setDefaultFont(int h, boolean large, boolean bold) {
        this.fsize = h;
        this.flarge = large;
        this.fbold = bold;
        this.ffactor = Global.getParameter("ffactor", 130);
        this.setFont(large, bold);
    }

    public void setFont(boolean large, boolean bold) {
        int size = this.fsize;
        if (large) {
            size = size * this.ffactor / 100;
        }
        if (this.flarge) {
            size = size * this.ffactor / 100;
        }
        this.setFont(size, bold || this.fbold);
    }

    public void drawImage(Image i, double x, double y, double x1, double y1, double x2, double y2, ImageObserver o) {
    }

    public Graphics getGraphics() {
        return null;
    }

    public int stringWidth(String s) {
        return this.getFontMetrics().stringWidth(s);
    }

    public int stringHeight(String s) {
        return this.getFontMetrics().getHeight();
    }

    public int drawStringExtended(String s, double x, double y) {
        this.drawString(s, x, y + (double)this.getFontMetrics().getAscent());
        return this.getFontMetrics().getHeight();
    }

    public int stringAscent(String s) {
        return this.getFontMetrics().getAscent();
    }
}

