/*
 * Decompiled with CFR 0.152.
 */
package rene.gui;

import java.awt.Color;
import rene.gui.IconBar;
import rene.gui.ToggleIcon;

class IconGroup {
    String[] Files;
    String[] Breaks;
    IconBar Bar;
    int N;
    ToggleIcon[] Icons;

    public IconGroup(IconBar bar, String[] files, String[] breaks) {
        this.Files = files;
        this.Breaks = breaks;
        this.Bar = bar;
        this.init();
    }

    public IconGroup(IconBar bar, String[] files) {
        this(bar, files, files);
    }

    public void init() {
        this.N = 0;
        int i = 0;
        while (i < this.Files.length) {
            if (!this.Files[i].equals("")) {
                ++this.N;
            }
            ++i;
        }
        this.Icons = new ToggleIcon[this.N];
        int k = 0;
        int i2 = 0;
        while (i2 < this.Files.length) {
            if (!this.Files[i2].equals("")) {
                this.Icons[k++] = new ToggleIcon(this.Bar, this.Files[i2], this);
            }
            ++i2;
        }
    }

    public IconGroup(IconBar bar, String name, int n) {
        this.Files = new String[n];
        this.Breaks = this.Files;
        int i = 0;
        while (i < n) {
            this.Files[i] = String.valueOf(name) + i;
            ++i;
        }
        this.Bar = bar;
        this.init();
    }

    public IconGroup(IconBar bar, String name, Color[] colors) {
        this.N = colors.length;
        this.Files = new String[this.N];
        this.Breaks = this.Files;
        int i = 0;
        while (i < this.N) {
            this.Files[i] = String.valueOf(name) + i;
            ++i;
        }
        this.Bar = bar;
        this.Icons = new ToggleIcon[this.N];
        i = 0;
        while (i < this.N) {
            this.Icons[i] = new ToggleIcon(this.Bar, this.Files[i], colors[i], this);
            ++i;
        }
    }

    public void addLeft() {
        int i = 0;
        int k = 0;
        while (k < this.Files.length) {
            if (this.Files[k].equals("")) {
                this.Bar.addSeparatorLeft();
            } else {
                if (this.Breaks[k].startsWith("!")) {
                    this.Bar.addSeparatorLeft();
                }
                this.Bar.addLeft(this.Icons[i++]);
            }
            ++k;
        }
    }

    public void addRight() {
        int i = 0;
        int k = 0;
        while (k < this.Files.length) {
            if (this.Files[k].equals("")) {
                this.Bar.addSeparatorRight();
            } else {
                if (this.Breaks[k].startsWith("!")) {
                    this.Bar.addSeparatorRight();
                }
                this.Bar.addRight(this.Icons[i++]);
            }
            ++k;
        }
    }

    public void toggle(ToggleIcon icon) {
        int i = 0;
        while (i < this.N) {
            if (this.Icons[i] == icon) {
                icon.setStateInGroup(true);
            } else {
                this.Icons[i].setStateInGroup(false);
            }
            this.Icons[i].unset(false);
            ++i;
        }
    }

    public void unselect() {
        int i = 0;
        while (i < this.N) {
            this.Icons[i].setStateInGroup(false);
            this.Icons[i].unset(false);
            ++i;
        }
    }

    public int getN() {
        return this.N;
    }

    public void unset(boolean flag) {
        int i = 0;
        while (i < this.N) {
            this.Icons[i].dounset(flag);
            ++i;
        }
    }
}

