/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.AreaObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;

public class AreaConstructor
extends ObjectConstructor {
    Vector Points = new Vector();

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (!zc.checkVisual()) {
            return;
        }
        double x = zc.x(e2.getX());
        double y = zc.y(e2.getY());
        PointObject P = zc.selectCreatePoint(e2.getX(), e2.getY());
        if (P != null) {
            P.setSelected(true);
            Enumeration en = this.Points.elements();
            while (en.hasMoreElements()) {
                if (en.nextElement() != P) continue;
                if (this.Points.size() >= 3) {
                    AreaObject o = new AreaObject(zc.getConstruction(), this.Points);
                    zc.addObject(o);
                    o.setDefaults();
                    if (!o.isSolid()) {
                        o.setBack(true);
                    }
                }
                this.reset(zc);
                return;
            }
            this.Points.addElement(P);
            zc.repaint();
        }
    }

    public String getTag() {
        return "Polygon";
    }

    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams < 3) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        Vector<ConstructionObject> v = new Vector<ConstructionObject>();
        int i = 0;
        while (i < nparams) {
            ConstructionObject o = c2.find(params[i]);
            if (o == null) {
                throw new ConstructionException(String.valueOf(Zirkel.name("exception.notfound")) + " " + params[i]);
            }
            if (!(o instanceof PointObject)) {
                throw new ConstructionException(String.valueOf(Zirkel.name("exception.type")) + " " + params[i]);
            }
            v.addElement(o);
            ++i;
        }
        AreaObject o = new AreaObject(c2, v);
        if (!name.equals("")) {
            o.setNameCheck(name);
        }
        c2.add(o);
        o.setDefaults();
        o.setBack(true);
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Polygon")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        try {
            PointObject p;
            int i = 1;
            Vector<PointObject> v = new Vector<PointObject>();
            while ((p = (PointObject)c2.find(tag.getValue("point" + i))) != null) {
                v.addElement(p);
                ++i;
            }
            AreaObject o = new AreaObject(c2, v);
            o.setBack(true);
            this.setName(tag, o);
            this.set(tree, o);
            c2.add(o);
            this.setConditionals(tree, c2, o);
        }
        catch (ConstructionException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new ConstructionException("Polygon parameters illegal!");
        }
        return true;
    }

    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Zirkel.name("message.area"));
        zc.setPrompt("=" + Zirkel.name("prompt.area"));
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        this.Points = new Vector();
        zc.showStatus(Zirkel.name("message.area"));
    }
}

