/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.AreaObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.UserFunctionObject;

public class SetParameterTool
extends ObjectConstructor
implements Selector {
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        double x = zc.x(e2.getX());
        double y = zc.y(e2.getY());
        ConstructionObject o = zc.selectWithSelector(e2.getX(), e2.getY(), this);
        if (o == null || o.isMainParameter()) {
            return;
        }
        o.setMainParameter();
        if (o.isMainParameter()) {
            o.setSelected(true);
            zc.getConstruction().addParameter(o);
            zc.repaint();
        }
        if (e2.isShiftDown()) {
            o.setSpecialParameter(true);
        }
    }

    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        return o instanceof PointObject || o instanceof PrimitiveLineObject || o instanceof PrimitiveCircleObject || o instanceof ExpressionObject || o instanceof AngleObject || o instanceof AreaObject || o instanceof FunctionObject || o instanceof UserFunctionObject;
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        zc.indicateWithSelector(e2.getX(), e2.getY(), this);
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.clearSelected();
        zc.getConstruction().clearParameters();
    }

    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Zirkel.name("message.parameters", "Macro Parameters: Select the Parameters!"));
    }
}

