/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.PointObject;

public class SetAwayTool
extends ObjectConstructor {
    ObjectConstructor OC;
    IntersectionObject P;
    boolean Away;

    public SetAwayTool(ZirkelCanvas zc, IntersectionObject p, boolean away, ObjectConstructor oc) {
        this.P = p;
        this.OC = oc;
        this.P.setSelected(true);
        this.Away = away;
        zc.repaint();
    }

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        PointObject o = zc.selectPoint(e2.getX(), e2.getY());
        if (o == null) {
            return;
        }
        if (zc.getConstruction().dependsOn(o, this.P)) {
            zc.warning(ConstructionObject.text1(Zirkel.name("error.depends"), this.P.getText()));
            return;
        }
        this.P.setAway(o.getName(), this.Away);
        this.P.setUseAlpha(e2.isShiftDown());
        zc.validate();
        this.reset(zc);
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.Away) {
            zc.showStatus(Zirkel.name("message.setaway.away"));
        } else {
            zc.showStatus(Zirkel.name("message.setaway.close"));
        }
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.setTool(this.OC);
        zc.validate();
        zc.repaint();
    }

    public boolean useSmartBoard() {
        return false;
    }
}

