/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.util.Enumeration;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;

public class Circle3Object
extends PrimitiveCircleObject {
    protected PointObject P1;
    protected PointObject P2;

    public Circle3Object(Construction c2, PointObject p1, PointObject p2, PointObject p3) {
        super(c2, p3);
        this.P1 = p1;
        this.P2 = p2;
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Circle3";
    }

    public void updateText() {
        this.setText(Circle3Object.text3(Zirkel.name("text.circle3"), this.M.getName(), this.P1.getName(), this.P2.getName()));
    }

    public void validate() {
        super.validate();
        if (!(this.M.valid() && this.P1.valid() && this.P2.valid())) {
            this.Valid = false;
            return;
        }
        this.Valid = true;
        this.X = this.M.getX();
        this.Y = this.M.getY();
        double DX = this.P2.getX() - this.P1.getX();
        double DY = this.P2.getY() - this.P1.getY();
        this.R = Math.sqrt(DX * DX + DY * DY);
        if (this.R < 0.0) {
            this.R = 0.0;
        }
    }

    public void printArgs(XmlWriter xml) {
        xml.printArg("from", this.P1.getName());
        xml.printArg("to", this.P2.getName());
        super.printArgs(xml);
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.R;
    }

    public Enumeration depending() {
        super.depending();
        return this.depset(this.P1, this.P2);
    }

    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
        this.P2 = (PointObject)this.P2.getTranslation();
        super.translate();
    }
}

