/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import rene.gui.Global;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.AreaObjectDialog;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;

public class AreaObject
extends ConstructionObject
implements InsideObject,
PointonObject,
MoveableObject {
    static Count N = new Count();
    double[] x = new double[3];
    double[] y = new double[3];
    double R;
    double X;
    double Y;
    double A;
    Vector V;
    boolean OnBoundary;
    double[] xd;
    double[] yd;
    double x1;
    double y1;

    public AreaObject(Construction c2, Vector v) {
        super(c2);
        this.V = v;
        this.validate();
        this.updateText();
        this.setDecorative(true);
        Global.getParameter("unit.area", "");
    }

    public String getTag() {
        return "Polygon";
    }

    public void updateText() {
        String Text = Zirkel.name("text.area");
        Enumeration en = this.V.elements();
        boolean first = true;
        while (en.hasMoreElements()) {
            PointObject p = (PointObject)en.nextElement();
            Text = !first ? String.valueOf(Text) + ", " : String.valueOf(Text) + " ";
            first = false;
            Text = String.valueOf(Text) + p.getName();
        }
        this.setText(Text);
    }

    public void setDefaults() {
        super.setDefaults();
        if (this.ColorType == 0) {
            this.setColorType(2);
        }
    }

    public void setTargetDefaults() {
        int colortype = this.ColorType;
        super.setTargetDefaults();
        this.setColorType(colortype);
    }

    public void validate() {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            if (((ConstructionObject)e2.nextElement()).valid()) continue;
            this.Valid = false;
            return;
        }
        if (this.V.size() < 3) {
            this.Valid = false;
            return;
        }
        Enumeration en = this.V.elements();
        double x = 0.0;
        double y = 0.0;
        while (en.hasMoreElements()) {
            PointObject p = (PointObject)en.nextElement();
            x += p.getX();
            y += p.getY();
        }
        this.X = x / (double)this.V.size();
        this.Y = y / (double)this.V.size();
        this.A = this.area();
        this.Valid = true;
    }

    public void edit(ZirkelCanvas zc) {
        AreaObjectDialog d2 = new AreaObjectDialog(zc.getFrame(), Zirkel.name("edit.area.title"), this);
        d2.setVisible(true);
        Global.setParameter("unit.area", this.Unit);
        zc.repaint();
        if (d2.wantsMore()) {
            new EditConditionals(zc.getFrame(), this);
            this.validate();
        }
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        String s;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        int n = this.V.size();
        if (this.x.length != n) {
            this.x = new double[n];
            this.y = new double[n];
        }
        if (this.visible(zc)) {
            Enumeration e2 = this.V.elements();
            int i = 0;
            while (e2.hasMoreElements()) {
                PointObject p = (PointObject)e2.nextElement();
                this.x[i] = zc.col(p.getX());
                this.y[i] = zc.row(p.getY());
                if (i > 0 && this.isStrongSelected() && g instanceof MyGraphics13) {
                    ((MyGraphics13)g).drawMarkerLine(this.x[i - 1], this.y[i - 1], this.x[i], this.y[i]);
                }
                ++i;
            }
            if (i > 1 && this.isStrongSelected() && g instanceof MyGraphics13) {
                ((MyGraphics13)g).drawMarkerLine(this.x[i - 1], this.y[i - 1], this.x[0], this.y[0]);
            }
            g.fillPolygon(this.x, this.y, n, this.Indicated || this.Selected || this.getColorType() != 2, this.getColorType() != 1 && !this.isFillBackground(), this);
        }
        if (!(s = this.getDisplayText()).equals("")) {
            if (this.getColorIndex() == 0 && this.getColorType() == 1) {
                g.setColor(Color.gray.brighter());
            } else {
                g.setColor(Color.black);
            }
            this.DisplaysText = true;
            this.TX1 = zc.col(this.X + this.XcOffset);
            this.TY1 = zc.row(this.Y + this.YcOffset);
            this.setFont(g);
            this.drawLabel(g, s);
        }
    }

    public String getDisplayValue() {
        return "" + this.round(Math.abs(this.A), ZirkelCanvas.LengthsFactor);
    }

    public void printArgs(XmlWriter xml) {
        Enumeration e2 = this.V.elements();
        int n = 1;
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            xml.printArg("point" + n, o.getName());
            ++n;
        }
        super.printArgs(xml);
    }

    public Enumeration depending() {
        super.depending();
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            DL.add(o);
        }
        return DL.elements();
    }

    public void translate() {
        Enumeration e2 = this.V.elements();
        Vector<ConstructionObject> w = new Vector<ConstructionObject>();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            w.addElement(o.getTranslation());
        }
        this.V = w;
    }

    public boolean nearto(int c2, int r, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        return this.contains(zc.x(c2), zc.y(r));
    }

    public boolean nearto(int c2, int r, boolean ignorefill, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        if (this.contains(zc.x(c2), zc.y(r), zc.dx(zc.selectionSize()))) {
            if (ignorefill) {
                return this.OnBoundary;
            }
            return true;
        }
        return false;
    }

    public boolean contains(double x, double y, double eps) {
        double d2;
        double b2;
        PointObject Q;
        if (!this.Valid) {
            return false;
        }
        this.OnBoundary = false;
        PointObject First = (PointObject)this.V.elementAt(0);
        PointObject P = First;
        if (Math.max(Math.abs(P.getX() - x), Math.abs(P.getY() - y)) < eps) {
            this.OnBoundary = true;
            return true;
        }
        Enumeration e2 = this.V.elements();
        double a2 = Math.atan2(P.getX() - x, P.getY() - y);
        double sum = 0.0;
        while (e2.hasMoreElements()) {
            Q = (PointObject)e2.nextElement();
            if (Math.max(Math.abs(Q.getX() - x), Math.abs(Q.getY() - y)) < eps) {
                this.OnBoundary = true;
                return true;
            }
            b2 = Math.atan2(Q.getX() - x, Q.getY() - y);
            d2 = b2 - a2;
            if (d2 > Math.PI) {
                d2 -= Math.PI * 2;
            } else if (d2 < -Math.PI) {
                d2 += Math.PI * 2;
            }
            if (Math.abs(Math.abs(d2) - Math.PI) < 0.1) {
                this.OnBoundary = true;
                return true;
            }
            a2 = b2;
            P = Q;
            sum += d2;
        }
        Q = First;
        b2 = Math.atan2(Q.getX() - x, Q.getY() - y);
        d2 = b2 - a2;
        if (d2 > Math.PI) {
            d2 -= Math.PI * 2;
        } else if (d2 < -Math.PI) {
            d2 += Math.PI * 2;
        }
        if (Math.abs(Math.abs(d2) - Math.PI) < 0.1) {
            this.OnBoundary = true;
            return true;
        }
        return Math.abs(sum += d2) >= 1.5707963267948966;
    }

    public boolean contains(double x, double y) {
        return this.contains(x, y, 1.0E-4);
    }

    public double area() {
        PointObject Q;
        PointObject First;
        if (!this.Valid) {
            return -1.0;
        }
        PointObject P = First = (PointObject)this.V.elementAt(0);
        Enumeration e2 = this.V.elements();
        double sum = 0.0;
        while (e2.hasMoreElements()) {
            Q = (PointObject)e2.nextElement();
            sum += (Q.getX() - this.X) * (P.getY() - this.Y) - (Q.getY() - this.Y) * (P.getX() - this.X);
            P = Q;
        }
        Q = First;
        return (sum += (Q.getX() - this.X) * (P.getY() - this.Y) - (Q.getY() - this.Y) * (P.getX() - this.X)) / 2.0;
    }

    public boolean equals(ConstructionObject o) {
        int k;
        int kj;
        int j;
        boolean r;
        if (!(o instanceof AreaObject) || !o.valid()) {
            return false;
        }
        AreaObject a2 = (AreaObject)o;
        int n = this.V.size();
        int m = a2.V.size();
        Object[] p = new PointObject[n];
        this.V.copyInto(p);
        Object[] pa = new PointObject[m];
        a2.V.copyInto(pa);
        double x0 = 0.0;
        double y0 = 0.0;
        int i = 0;
        while (i < m) {
            r = true;
            j = 0;
            kj = 0;
            do {
                if ((k = i + kj) >= m) {
                    k -= m;
                }
                if (!((PointObject)p[j]).equals((ConstructionObject)pa[k])) {
                    if (j != 0 && this.between(x0, y0, ((PointObject)p[j]).getX(), ((PointObject)p[j]).getY(), ((PointObject)pa[k]).getX(), ((PointObject)pa[k]).getY())) continue;
                    r = false;
                    break;
                }
                x0 = ((PointObject)p[j]).getX();
                y0 = ((PointObject)p[j]).getY();
                ++j;
            } while (j < n && ++kj < m);
            if (r && kj >= m) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < m) {
            r = true;
            j = 0;
            kj = 0;
            do {
                if ((k = i + kj) >= m) {
                    k -= m;
                }
                if (!((PointObject)p[n - j - 1]).equals((ConstructionObject)pa[k])) {
                    if (j != 0 && this.between(x0, y0, ((PointObject)p[n - j - 1]).getX(), ((PointObject)p[n - j - 1]).getY(), ((PointObject)pa[k]).getX(), ((PointObject)pa[k]).getY())) continue;
                    r = false;
                    break;
                }
                x0 = ((PointObject)p[n - j - 1]).getX();
                y0 = ((PointObject)p[n - j - 1]).getY();
                ++j;
            } while (j < n && ++kj < m);
            if (r && kj >= m) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean between(double x0, double y0, double x1, double y1, double x, double y) {
        double lambda = Math.abs(x1 - x0) > Math.abs(y1 - y0) ? (x - x0) / (x1 - x0) : (y - y0) / (y1 - y0);
        return Math.abs(x0 + lambda * (x1 - x0) - x) < 1.0E-10 && Math.abs(y0 + lambda * (y1 - y0) - y) < 1.0E-10;
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.A;
    }

    public boolean maybeTransparent() {
        return true;
    }

    public boolean isFilled() {
        return true;
    }

    public boolean onlynearto(int x, int y, ZirkelCanvas zc) {
        return false;
    }

    public void project(PointObject P) {
        double dist;
        double yh;
        double xh;
        double h;
        double r;
        double y2;
        double dy;
        double dx;
        double x2;
        double x = P.getX();
        double y = P.getY();
        Enumeration e2 = this.V.elements();
        PointObject p = (PointObject)e2.nextElement();
        double x1 = p.getX();
        double y1 = p.getY();
        double xstart = x1;
        double ystart = y1;
        int count = 0;
        double xmin = x1;
        double ymin = y1;
        double dmin = 1.0E20;
        double hmin = 0.0;
        while (e2.hasMoreElements()) {
            p = (PointObject)e2.nextElement();
            x2 = p.getX();
            dx = x2 - x1;
            r = dx * dx + (dy = (y2 = p.getY()) - y1) * dy;
            if (r > 1.0E-5) {
                h = dx * (x - x1) / r + dy * (y - y1) / r;
                if (h > 1.0) {
                    h = 1.0;
                } else if (h < 0.0) {
                    h = 0.0;
                }
                xh = x1 + h * dx;
                yh = y1 + h * dy;
                dist = Math.sqrt((x - xh) * (x - xh) + (y - yh) * (y - yh));
                if (dist < dmin) {
                    dmin = dist;
                    xmin = xh;
                    ymin = yh;
                    hmin = (double)count + h;
                }
            }
            ++count;
            x1 = x2;
            y1 = y2;
        }
        x2 = xstart;
        dx = x2 - x1;
        y2 = ystart;
        dy = y2 - y1;
        r = dx * dx + dy * dy;
        if (r > 1.0E-5) {
            h = dx * (x - x1) / r + dy * (y - y1) / r;
            if (h > 1.0) {
                h = 1.0;
            } else if (h < 0.0) {
                h = 0.0;
            }
            xh = x1 + h * dx;
            yh = y1 + h * dy;
            dist = Math.sqrt((x - xh) * (x - xh) + (y - yh) * (y - yh));
            if (dist < dmin) {
                dmin = dist;
                xmin = xh;
                ymin = yh;
                hmin = (double)count + h;
            }
        }
        P.move(xmin, ymin);
        P.setA(hmin);
    }

    public void project(PointObject P, double alpha) {
        int i = (int)Math.floor(alpha);
        double h = alpha - (double)i;
        if (i < 0 || i >= this.V.size()) {
            this.project(P);
            return;
        }
        PointObject P1 = (PointObject)this.V.elementAt(i);
        PointObject P2 = i == this.V.size() - 1 ? (PointObject)this.V.elementAt(0) : (PointObject)this.V.elementAt(i + 1);
        P.setXY(P1.getX() + h * (P2.getX() - P1.getX()), P1.getY() + h * (P2.getY() - P1.getY()));
    }

    public double containsInside(PointObject P) {
        boolean inside = this.contains(P.getX(), P.getY());
        if (inside && this.OnBoundary) {
            return 0.5;
        }
        if (inside) {
            return 1.0;
        }
        return 0.0;
    }

    public boolean keepInside(PointObject P) {
        if (this.containsInside(P) > 0.0) {
            return true;
        }
        this.project(P);
        return false;
    }

    public boolean dragTo(double x, double y) {
        Enumeration e2 = this.V.elements();
        int i = 0;
        while (e2.hasMoreElements()) {
            PointObject p = (PointObject)e2.nextElement();
            p.move(this.xd[i] + (x - this.x1), this.yd[i] + (y - this.y1));
            ++i;
        }
        return true;
    }

    public void move(double x, double y) {
    }

    public boolean moveable() {
        if (this.V == null) {
            return false;
        }
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            if (((PointObject)e2.nextElement()).moveable()) continue;
            return false;
        }
        return true;
    }

    public boolean startDrag(double x, double y) {
        if (this.xd == null || this.xd.length != this.V.size()) {
            this.xd = new double[this.V.size()];
            this.yd = new double[this.V.size()];
        }
        Enumeration e2 = this.V.elements();
        int i = 0;
        while (e2.hasMoreElements()) {
            PointObject p = (PointObject)e2.nextElement();
            this.xd[i] = p.getX();
            this.yd[i] = p.getY();
            ++i;
        }
        this.x1 = x;
        this.y1 = y;
        return true;
    }

    public void snap(ZirkelCanvas zc) {
        if (this.moveable()) {
            Enumeration e2 = this.V.elements();
            while (e2.hasMoreElements()) {
                PointObject p = (PointObject)e2.nextElement();
                p.snap(zc);
            }
        }
    }

    public boolean canInteresectWith(ConstructionObject o) {
        Enumeration e2;
        PointObject P;
        ConstructionObject line;
        return !(o instanceof PointonObject) || !(line = o).contains(P = (PointObject)(e2 = this.V.elements()).nextElement());
    }

    public boolean canBeReplacedBy(ConstructionObject o) {
        return o instanceof AreaObject;
    }
}

