/*
 * ledzenie i wywietlanie aktualnej lokalizacji
 */
var handlePositionUpdate = function(e) {
    var latitude = e.coords.latitude;
    var longitude = e.coords.longitude;
    log("Aktualizacja lokalizacji:", latitude, longitude);
    if(navigator.onLine) {
        uploadLocations(latitude, longitude);
    }
    storeLocation(latitude, longitude);
}

var handlePositionError = function(e) {
    log("Bd lokalizacji");
}

var uploadLocations = function(latitude, longitude) {
    var request = new XMLHttpRequest();
    request.open("POST", "http://geodata.example.net:8000/geoupload", true);
    request.send(localStorage.locations);
}

var storeLocation = function(latitude, longitude) {
    // zaadowanie przechowywanych lokalizacji
    var locations = JSON.parse(localStorage.locations || "[]");
    // dodanie lokalizacji
    locations.push({"szeroko" : latitude, "dugo" : longitude});
    // zapisanie nowych lokalizacji
    localStorage.locations = JSON.stringify(locations);
}

var geolocationConfig = {"maximumAge":20000};

navigator.geolocation.watchPosition(handlePositionUpdate,
                                    handlePositionError,
                                    geolocationConfig);
