/* myLoc.js */

var watchId = null;
var map = null;
var ourCoords =  {
	latitude: 50.288236,
	longitude: 18.659247
};
var prevCoords = null;

window.onload = getMyLocation;

function getMyLocation() {
	if (navigator.geolocation) {

		navigator.geolocation.getCurrentPosition(
			displayLocation, 
			displayError,
			{enableHighAccuracy: true, timeout:9000});

		var watchButton = document.getElementById("watch");
		watchButton.onclick = watchLocation;
		var clearWatchButton = document.getElementById("clearWatch");
		clearWatchButton.onclick = clearWatch;
	}
	else {
		alert("Oj! Brak wsparcia dla geolokalizacji.");
	}
}

function displayLocation(position) {
	var latitude = position.coords.latitude;
	var longitude = position.coords.longitude;

	var div = document.getElementById("location");
	div.innerHTML = "Jesteś na szerokości " + latitude + " i długości " + longitude;
	div.innerHTML += " (z dokładnością do " + position.coords.accuracy + " m)";

	var km = computeDistance(coords, ourCoords);
	var distance = document.getElementById("distance");
	distance.innerHTML = "Jesteś " + km + " km od siedziby Helionu";

	if (map == null) {
		showMap(position.coords);
		prevCoords = position.coords;
	}
	else {
		var meters = computeDistance(position.coords, prevCoords) * 1000;
		if (meters > 20) {
			scrollMapToPosition(position.coords);
			prevCoords = position.coords;
		}
	}
}


// --------------------- Gotowy kod ------------------
//
// Za pomocą twierdzenia cosinusów dla sfery obliczamy
// odległość między dwoma punktami określonymi przez 
// szerokość i długość geograficzną.
//
function computeDistance(startCoords, destCoords) {
	var startLatRads = degreesToRadians(startCoords.latitude);
	var startLongRads = degreesToRadians(startCoords.longitude);
	var destLatRads = degreesToRadians(destCoords.latitude);
	var destLongRads = degreesToRadians(destCoords.longitude);

	var Radius = 6371; // promień Ziemi w km
	var distance = Math.acos(Math.sin(startLatRads) * Math.sin(destLatRads) + 
					Math.cos(startLatRads) * Math.cos(destLatRads) *
					Math.cos(startLongRads - destLongRads)) * Radius;

	return distance;
}

function degreesToRadians(degrees) {
	radians = (degrees * Math.PI)/180;
	return radians;
}

// ------------------ Koniec gotowego kodu -----------------

function showMap(coords) {
	var googleLatAndLong = new google.maps.LatLng(coords.latitude, 
												  coords.longitude);
	var mapOptions = {
		zoom: 10,
		center: googleLatAndLong,
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};
	var mapDiv = document.getElementById("map");
	map = new google.maps.Map(mapDiv, mapOptions);

	// dodaje znacznik użytkownika
	var title = "Twoja lokalizacja";
	var content = "Jesteś tu: " + coords.latitude + ", " + coords.longitude;
	addMarker(map, googleLatAndLong, title, content);

/*
	// dodaje znacznik siedziby Helionu
	var wsLatLong = new google.maps.LatLng(
							ourCoords.latitude, 
							ourCoords.longitude);
	addMarker(map, wsLatLong, "Siedziba Helionu", 
							"Współrzędne siedziby Helionu: szerokość " + 
							ourCoords.latitude + 
							", długość " +
							ourCoords.longitude);
*/
}

function addMarker(map, latlong, title, content) {
	var markerOptions = {
		position: latlong,
		map: map,
		title: title,
		clickable: true
	};
	var marker = new google.maps.Marker(markerOptions);

	var infoWindowOptions = {
		content: content,
		position: latlong
	};

	var infoWindow = new google.maps.InfoWindow(infoWindowOptions);

	google.maps.event.addListener(marker, 'click', function() {
		infoWindow.open(map);
	});
}


function displayError(error) {
	var errorTypes = {
		0: "Nieznany błąd",
		1: "Dostęp zabroniony przez użytkownika",
		2: "Położenie jest niedostępne",
		3: "Zbyt długi czas oczekiwania"
	};
	var errorMessage = errorTypes[error.code];
	if (error.code == 0 || error.code == 2) {
		errorMessage = errorMessage + " " + error.message;
	}
	var div = document.getElementById("location");
	div.innerHTML = errorMessage;
}

//
// Kod odpowiedzialny za śledzenie położenia użytkownika
//
function watchLocation() {
	watchId = navigator.geolocation.watchPosition(
					displayLocation, 
					displayError,
					{enableHighAccuracy: true, timeout:3000});
}

function scrollMapToPosition(coords) {
	var latitude = coords.latitude;
	var longitude = coords.longitude;

	var latlong = new google.maps.LatLng(latitude, longitude);
	map.panTo(latlong);

	// dodaje nowy znacznik
	addMarker(map, latlong, "Twoja nowa lokalizacja", "Przeniosłeś się do: " +
	          latitude +  ", " + longitude);
}

function clearWatch() {
	if (watchId) {
		navigator.geolocation.clearWatch(watchId);
		watchId = null;
	}
}


