/* 
 * mandel.js
 */

var numberOfWorkers = 8;
var workers = [];
var rowData;
var nextRow = 0;
var generation = 0;

window.onload = init;

function init() {
	setupGraphics();

	//
	// Po kliknięciu płótna jest wywoływana funkcja obsługi tego zdarzenia.
	// Przekazywany jest obiekt event, który zawiera współrzędne x i y
	// punktu kliknięcia. Przekazujemy te wartości do funkcji obsługi kliknięcia.
	//
	canvas.onclick = function(event) {
		handleClick(event.clientX, event.clientY);
	};
	//
	// Po przeskalowaniu okna przeglądarki musimy przeskalować
	// płótno i ponownie uruchomić wątki.
	//
	window.onresize = function() {
		resizeToWindow();
	};

	//
	// Tworzymy wszystkie wątki i ustawiamy funkcje obsługi komunikatu.  
	// Wątki umieszczamy w tablicy workers.
	//
	for (var i = 0; i < numberOfWorkers; i++) {
		var worker = new Worker("worker.js");

		worker.onmessage = function(event) {
			processWork(event.target, event.data)
		}

		worker.idle = true;
		workers.push(worker);
	}

	//
	// Uruchamiamy wątki.
	//
	startWorkers();

}

//
// startWorkers
//	Ta funkcja resetuje wątki, tak by rozpoczęły obliczenia
//  od samej góry obrazu fraktala (wiersz 0). Przechodzimy
//	w pętli po wszystkich wątkach z tablicy workers 
//	i przypisujemy każdemu z nich zadanie obliczenia wiersza.
//	Poprzez wysłanie komunikatu uruchamiamy wątek,
//  który rozpoczyna obliczenia.
//
function startWorkers() {
	generation++;
	nextRow = 0;
	for (var i = 0; i < workers.length; i++) {
		var worker = workers[i];
		if (worker.idle) {
			var task = createTask(nextRow);
			worker.idle = false;
			worker.postMessage(task);
			nextRow++;
		}
	}
} 

//
// processWork
// 	Tę funkcję wywołujemy gdy wątek odsyła komunikat wraz z wynikami.
//	Jeśli wątek pracuje nad bieżącą generacją fraktala, rysujemy
//  otrzymany wiersz obrazu,a  w przeciwnym przypadku ignorujemy dane.
//	Po wykorzystaniu danych przypisujemy wątkowi kolejne zadanie.
//    
function processWork(worker, workerResults) {
	if (workerResults.generation == generation) {
		drawRow(workerResults);
	}
	reassignWorker(worker);
}

//
// reassignWorker
//	Ta funkcja zleca bezczynnemu wątkowi kolejne zadanie.
//
function reassignWorker(worker) {
	var row = nextRow++;
	if (row >= canvas.height) {
		worker.idle = true;
	} else {
		var task = createTask(row);
		worker.idle = false;
		worker.postMessage(task);
	}
}


// handleClick
//	Ta funkcja przyjmuje współrzędne x i y kliknięcia
//  płótna i ustala parametry nowego fraktala.
//	Współczynnik zoom ustawia nowy zakres zbioru Mandelbrota.
//	Nowy fraktal zachowuje stosunek szerokości do wysokości
//	bieżącego płótna. 
//  Uruchamiamy wątki, by obliczyły dane dla powiększonego fraktala.
//
function handleClick(x, y) {
	var width = r_max - r_min;
	var height = i_min - i_max;
	var click_r = r_min + ((width * x) / canvas.width);
	var click_i = i_max + ((height * y) / canvas.height);

	var zoom = 8;

	r_min = click_r - width/zoom;
	r_max = click_r + width/zoom;
	i_max = click_i - height/zoom;
	i_min = click_i + height/zoom;

	startWorkers();
}

//
// resizeToWindow
//	Gdy użytkownik przeskaluje okno przeglądarki,
//	jest wywoływana ta funkcja. Jej zadaniem jest
//	przeskalowanie płótna i przywrócenie domyślnych
//  wartości	parametrów fraktala (zmiana zakresu
//	fraktala i zachowanie stosunku szerokości do 
//	wysokości).
//	Ponownie uruchamiamy wątki, by obliczyły dane 
//	dla nowego fraktala o ustalonej wielkości.
//
function resizeToWindow() {
	canvas.width = window.innerWidth;
	canvas.height = window.innerHeight;
	var width = ((i_max - i_min) * canvas.width / canvas.height);
	var r_mid = (r_max + r_min) / 2;
	r_min = r_mid - width/2;
	r_max = r_mid + width/2;
	rowData = ctx.createImageData(canvas.width, 1);

	startWorkers();
}

