/* myLoc.js */


window.onload = getMyLocation;

function getMyLocation() {
	if (navigator.geolocation) {

		navigator.geolocation.getCurrentPosition(
			displayLocation, 
			displayError);
	}
	else {
		alert("Oj! Brak wsparcia dla geolokalizacji.");
	}
}

function displayLocation(position) {
	var latitude = position.coords.latitude;
	var longitude = position.coords.longitude;

	var div = document.getElementById("location");
	div.innerHTML = "Jesteś na szerokości " + latitude + " i długości " + longitude;

}

function displayError(error) {
	var errorTypes = {
		0: "Nieznany błąd",
		1: "Dostęp zabroniony przez użytkownika",
		2: "Położenie jest niedostępne",
		3: "Zbyt długi czas oczekiwania"
	};
	var errorMessage = errorTypes[error.code];
	if (error.code == 0 || error.code == 2) {
		errorMessage = errorMessage + " " + error.message);
	}
	var div = document.getElementById("location");
	div.innerHTML = errorMessage;
}

