// Funkcja ta przechowuje informacje o pojedynyczm okrgu.
function Circle(x, y, radius, color) {
  this.x = x;
  this.y = y;
  this.radius = radius;
  this.color = color;
  this.isSelected = false;
}

// W tej tablicy zapisuje si wszystki narysowane na ptnie koa. 
var circles = [];

var canvas;
var context;

window.onload = function() {
  canvas = document.getElementById("canvas");
  context = canvas.getContext("2d");

  canvas.onmousedown = canvasClick;
  canvas.onmouseup = stopDragging;
  canvas.onmouseout = stopDragging;
  canvas.onmousemove = dragCircle;
};

function addRandomCircle() {
  // Nadaje kou losowy rozmiar i pooenie na ptnie.
  var radius = randomFromTo(10, 60);
  var x = randomFromTo(0, canvas.width);
  var y = randomFromTo(0, canvas.height);

  // Nadaje kou losow barw. 
  var colors = ["green", "blue", "red", "yellow", "magenta", "orange", "brown", "purple", "pink"];
  var color = colors[randomFromTo(0, 8)];

  // Tworzy nowe koo.
  var circle = new Circle(x, y, radius, color);

  // Zapisuje koo w tablicy.
  circles.push(circle);

  // Ponownie wypenia ptno. 
  drawCircles();
}

function clearCanvas() {
  // Usuwa wszystkie koa z tablicy.
  circles = [];

  // Uaktualnia ptno.
  drawCircles();
}

function drawCircles() {
  // Czyci ptno.
  context.clearRect(0, 0, canvas.width, canvas.height);

  // Przechodzie przez wszystkie zapisane koa.
  for(var i=0; i<circles.length; i++) {
    var circle = circles[i];

    // Rysuje wybrane koo.
    context.globalAlpha = 0.85;
    context.beginPath();
    context.arc(circle.x, circle.y, circle.radius, 0, Math.PI*2);
    context.fillStyle = circle.color;
    context.strokeStyle = "black";

    if (circle.isSelected) {
      context.lineWidth = 5;
    }
    else {
      context.lineWidth = 1;
    }
    context.fill();
    context.stroke(); 
  }
}

var previousSelectedCircle;

function canvasClick(e) {
  // Odczytuje wsprzdne punktu kliknitego przez uytkownika. 
  var clickX = e.pageX - canvas.offsetLeft;
  var clickY = e.pageY - canvas.offsetTop;

  // Sprawdza, ktre z k zostao kliknite.
  for(var i=circles.length-1; i>=0; i--) {
    var circle = circles[i];

    var distanceFromCenter = Math.sqrt(Math.pow(circle.x - clickX, 2) + Math.pow(circle.y - clickY, 2))
    if (distanceFromCenter <= circle.radius) {
      if (previousSelectedCircle != null) previousSelectedCircle.isSelected = false;
      previousSelectedCircle = circle;

      circle.isSelected = true;

      // Pozwala funkcji dragCircle na przecignicie koa.
      isDragging = true;

      drawCircles();
      return;
    }
  }
}

var isDragging = false;

function stopDragging() {
  isDragging = false;
}

function dragCircle(e) {
  // Czy koo jest przecigane?
  if (isDragging == true) {
    // Na wszelki wypadek sprawdza, czy aby na pewno przeciganym obiektem jest koo.
    if (previousSelectedCircle != null) {
      // Znajduje nowe wsprzdne kursora myszy.
      var x = e.pageX - canvas.offsetLeft;
      var y = e.pageY - canvas.offsetTop;

      // Przesuwa koo w to miejsce.
      previousSelectedCircle.x = x;
      previousSelectedCircle.y = y;

      // Uaktualnia ptno.
      drawCircles();
    }
  }
}


function randomFromTo(from, to) {
  return Math.floor(Math.random() * (to - from + 1) + from);
}
