/***
 * Plik przykładowy z książki "HTML5 i CSS3. Standardy przyszłości",
 * wydanej przez Wydawnictwo Helion S.A.
 * Kod źródłowy jest chroniony prawem autorskim. Kodu nie można używać jako materiałów pomocniczych, 
 * w trakcie szkoleń, w książkach, artykułach itp. W razie wątpliwości prosimy o kontakt z wydawnictwem.
 * Wydawnictwo nie gwarantuje bezbłędnego działania przykładowego kodu.
 * Więcej informacji na temat książki znajduje się na stronie wydawnictwa pod adresem http://helion.pl.
***/
// Wykorzystano skrypt http://www.morethannothing.co.uk/wp-content/uploads/2010/01/placeholder.js
// Wykorzystano skrypt http://plugins.jquery.com/files/jquery-placeholder-0.1.js.txt

(function($){  
  
  $.fn.placeholder = function(){   
    
    function valueIsPlaceholder(input){
      return ($(input).val() == $(input).attr("placeholder"));
    }
    return this.each(function() {  
  
      $(this).find(":input").each(function(){
      
        if($(this).attr("type") == "password"){ 
          
          var new_field = $("<input type='text'>");
          new_field.attr("rel", $(this).attr("id"));
          new_field.attr("value", $(this).attr("placeholder"));
          $(this).parent().append(new_field);
          new_field.hide();
          
          function showPasswordPlaceHolder(input){
            if( $(input).val() == "" || valueIsPlaceholder(input) ){ 
              $(input).hide();
              $('input[rel=' + $(input).attr("id") + ']').show();
            };
          };
          
          new_field.focus(function(){
            $(this).hide();
            $('input#' + $(this).attr("rel")).show().focus();
          });

          $(this).blur(function(){
             showPasswordPlaceHolder(this, false);
          });

          showPasswordPlaceHolder(this); 
        
        }else{
          
          // Zastąpienie wartości tekstem zastępczym. 
          // Opcjonalny parametr reload pozwala na zapisywanie wartości pól
		  // w pamięci podręcznej przez FF i IE.
          function showPlaceholder(input, reload){
            if( $(input).val() == "" || 
              ( reload && valueIsPlaceholder(input) ) ){ 
                $(input).val($(input).attr("placeholder"));
              }
          };
          
          $(this).focus(function(){
            if($(this).val() == $(this).attr("placeholder")){
              $(this).val("");
            };
          });

          $(this).blur(function(){
             showPlaceholder($(this), false)
          });
          
          
          showPlaceholder(this, true); 
        };
      });
      
      // Zapobiega wysłaniu formularza z wartościami domyślnymi
      $(this).submit(function(){  
        $(this).find(":input").each(function(){
          if($(this).val() == $(this).attr("placeholder")){
            $(this).val("");
          }          
        });
      });
      
    });  
  };
  
})(jQuery); 

