﻿/***
 * Plik przykładowy z książki "HTML5 i CSS3. Standardy przyszłości",
 * wydanej przez Wydawnictwo Helion S.A.
 * Kod źródłowy jest chroniony prawem autorskim. Kodu nie można używać jako materiałów pomocniczych, 
 * w trakcie szkoleń, w książkach, artykułach itp. W razie wątpliwości prosimy o kontakt z wydawnictwem.
 * Wydawnictwo nie gwarantuje bezbłędnego działania przykładowego kodu.
 * Więcej informacji na temat książki znajduje się na stronie wydawnictwa pod adresem http://helion.pl.
***/
// Odwołanie do bazy danych
var db = null;

// Utworzenie połączenia do lokalnej bazy danych
connectToDB = function()
{
   db = window.openDatabase('awesome_notes', '1.0',
                                   'AwesomeNotes Database', 1024*1024*3);
};



// Metoda, która tworzy tabelę
createNotesTable = function()
{
  db.transaction(function(tx){
    tx.executeSql(
      "CREATE TABLE notes (id INTEGER \
       PRIMARY KEY, title TEXT, note TEXT)", [],
      function(){ alert('Baza notatek została utworzona!'); },
      function(tx, error){ alert(error.message); } );
  });
};

// Wstawienie rekordu do tabeli
insertNote = function(title, note)
{
   db.transaction(function(tx){
      tx.executeSql("INSERT INTO notes (title, note) VALUES (?, ?)", 
                     [title.val(), note.val()],
        function(tx, result){ 
         var id = result.insertId ;
         alert('Rekord numer ' + id+ 'został zapisany!');
         title.attr("data-id", result.insertId );
         addToNotesList(id, title.val());
         $("#delete_button").show();
         
        },
        function(){ 
          alert('Notatki nie udało się zapisać.'); 
        }
      );
   });
};


/* Zmiana rekordu w tabeli. Odczytanie pól Tytuł i Notatka, które są obiektami jQuery.
   Identyfikator id rekordu do zmiany to atrybut danych użytkownika dla pola tytułu.
*/

updateNote = function(title, note)
{
   var id = title.attr("data-id");
   db.transaction(function(tx){
    tx.executeSql("UPDATE notes set title = ?, note = ? where id = ?",
                  [title.val(), note.val(), id],
      function(tx, result){ 
        alert('Rekord numer ' + id + ' został zmieniony!');
        $("#notes>li[data-id=" + id + "]").html(title.val());
      },
      function(){ 
        alert('Notatka nie została zmieniona!');
      }
    );
  });
};


// Usunięcie rekordu z tabeli
deleteNote = function(title)
{
   var id = title.attr("data-id");
   db.transaction(function(tx){
      tx.executeSql("DELETE from notes where id = ?", [id],
        function(tx, result){ 
         alert('Rekord numer ' + id + ' został usunięty!');
         $("#notes>li[data-id=" + id + "]").remove();
        },
        function(){ 
         alert('Notatka nie została usunięta!');
        }
      );
   });
};



// Wczytanie wszystkich rekordów notatek z tabeli bazy danych
fetchNotes = function(){
  db.transaction(function(tx) {
      tx.executeSql('SELECT id, title, note FROM notes', [],
        function(SQLTransaction, data){
          for (var i = 0; i < data.rows.length; ++i) {
              var row = data.rows.item(i);
              var id = row['id'];
              var title = row['title'];

              addToNotesList(id, title);
          }
      });
  });
};

// Dodanie do listy notatek pozycji o danym id i tytule
addToNotesList = function(id, title){
  var notes = $("#notes");
  var item = $("<li>");
  item.attr("data-id", id);
  item.html(title);               
  notes.append(item);
};


// Wczytanie z tabeli notatek notatki o podanym id
loadNote = function(id){
  db.transaction(function(tx) {
    tx.executeSql('SELECT id, title, note FROM notes where id = ?', [id],
      function(SQLTransaction, data){
        var row = data.rows.item(0);
        var title = $("#title");
        var note = $("#note");

        title.val(row["title"]);
        title.attr("data-id", row["id"]);
        note.val(row["note"]);
        $("#delete_button").show();

      });
  });
}



// Wyczyszczenie formularza i usunięcie przycisku "Usuń"
newNote = function(){
  $("#delete_button").hide();
  var title = $("#title");
  title.removeAttr("data-id");
  title.val("");
  var note = $("#note");
  note.val("");
}


$(function(){
  connectToDB();
  createNotesTable();
  fetchNotes();

  
  $("#save_button").click(function(event){
    event.preventDefault();
    var title = $("#title");
    var note = $("#note");
    
    if(title.attr("data-id")){
      updateNote(title, note);
    }else{
      insertNote(title, note);
    }
  });

  
  $("#delete_button").click(function(event){
    event.preventDefault();
    var title = $("#title");
    deleteNote(title);
  });
  
  $("#notes").click(function(event){
    if ($(event.target).is('li')) {
      var element = $(event.target);
      loadNote(element.attr("data-id"));
    }
    
  });
  
  $("#new_button").click(function(event){
    event.preventDefault();
    newNote();
  });
  //koniec:newbutton
  
  
  newNote();  
  
});

