/***
 * Plik przykadowy z ksiki "HTML5 i CSS3. Standardy przyszoci",
 * wydanej przez Wydawnictwo Helion S.A.
 * Kod rdowy jest chroniony prawem autorskim. Kodu nie mona uywa jako materiaw pomocniczych, 
 * w trakcie szkole, w ksikach, artykuach itp. W razie wtpliwoci prosimy o kontakt z wydawnictwem.
 * Wydawnictwo nie gwarantuje bezbdnego dziaania przykadowego kodu.
 * Wicej informacji na temat ksiki znajduje si na stronie wydawnictwa pod adresem http://helion.pl.
***/
/* Obsuga zaokrglania rogw dla starszych przegldarek */

/* na podstawie http://perfectionkills.com/feature-testing-css-properties/ */
function hasBorderRadius(){
  var element = document.documentElement;
  var style = element.style;
  if (style){
    return typeof style.borderRadius == "string" ||
      typeof style.MozBorderRadius == "string" ||
      typeof style.WebkitBorderRadius == "string" ||
      typeof style.KhtmlBorderRadius == "string";
  }
  return null;
}

(function($){  

  $.fn.formCorner = function(){   
    return this.each(function() {  
      var input = $(this);
      var input_background = input.css("background-color");
      var input_border = input.css("border-color");
      input.css("border", "none");
      var wrap_width = parseInt(input.css("width")) + 4;
      var wrapper = input.wrap("<div></div>").parent();
      var border = wrapper.wrap("<div></div>").parent();
      wrapper.css("background-color", input_background)
             .css("padding", "1px");
      border.css("background-color",input_border)
            .css("width", wrap_width + "px")
            .css('padding', '1px');
      wrapper.corner("round 5px");
      border.corner("round 5px");
    });  
  };  
})(jQuery); 

$(function(){
  if(!hasBorderRadius()){
    $("input").formCorner();
    $("fieldset").corner("round 5px");
    $("legend").corner("round top 5px cc:#fff");  
  }
});
