<?php

/*
 * Domylnie wysyamy text/html
 * Badamy wycznie jeden typ XHTML: application/xhtml+xml
 * Nie badamy typw: application/xml, ani application/xhtml
 *
 */

function httpaccept_parse($AStr)
{
    $AStr   = strtolower(trim($AStr));
    $t1     = explode(',', $AStr);
    $result = array();
    foreach ($t1 as $e) {
        $e  = trim($e);
        $t2 = explode(';', $e);
        if (count($t2) === 2) {

            /*
             * Naglowek z jednym srednikiem
             * np. image/png;q=0.9
             *
             * Badamy skladnie napisu po sredniku.
             */
            $k = trim($t2[0]);
            if (ereg("q=(1|0|(0\.[0-9]+))", $t2[1], $regs)) {

                /*
                 * Poprawny naglowek postaci
                 * image/png;q=0.123
                 */
                $result[$k] = $regs[1];

            } else {

                /*
                 * Bledny naglowek.
                 * Napis po sredniku
                 * nie jest postaci q=0.123
                 *
                 */
                return false;

            }
        } elseif (count($t2) === 1) {

            /*
             * Element bez srednika
             * np. image/png
             *
             */
            $result[$e] =  1;

        } else {

            /*
             * Bledny naglowek.
             * Zawiera conajmniej dwa sredniki.
             * image/png;xxx;yyy
             *
             */
            return false;

        }
    }

    return $result;
}

function httpaccept_add_html_xhtml($AAccept)
{
    if (!isset($AAccept['application/xhtml+xml'])) {
        $AAccept['application/xhtml+xml'] = 0.2;
    }

    if (!isset($AAccept['text/html'])) {
        $AAccept['text/html'] = 0.3;
    }

    return $AAccept;
}

function httpaccept_is_xhtml($AAccept)
{
    if (
        isset($AAccept['application/xhtml+xml']) &&
        isset($AAccept['text/html']) &&
        ($AAccept['application/xhtml+xml'] >= $AAccept['text/html'])
    ) {
        return true;
    } else {
        return false;
    }
}

function httpaccept_default_header($ACharset = 'utf-8')
{
    return "Content-Type: text/html; charset=$ACharset";
}

function httpaccept_xhtml_header($ACharset = 'utf-8')
{
    return "Content-Type: application/xhtml+xml; charset=$ACharset";
}

function httpaccept_send_header($ACharset = 'utf-8')
{
    $accept_array = httpaccept_parse($_SERVER['HTTP_ACCEPT']);

    if ($accept_array === false) {
        $tmp_header = httpaccept_default_header($ACharset);
        header($tmp_header);
        return false;
    } else {
        $accept_array = httpaccept_add_html_xhtml($accept_array);
        $is_xhtml     = httpaccept_is_xhtml($accept_array);
        if ($is_xhtml) {
            header(httpaccept_xhtml_header($ACharset));
            return true;
        } else {
            header(httpaccept_default_header($ACharset));
            return false;
        }
    }
}


?>
