unit stalekolorow;

interface

uses
  Graphics,SysUtils,Math;

const
 R_MIN =        10;
 R_MAX = 990000000;


 clCzarny              = clBlack;
 clBrazowy             = 5263520;
 clCzerwony            = 2237183;
 clPomaranczowy        = 5286910;
 clZolty               = 9370610;
 clZielony             = 4440078;
 clNiebieski           = 16615723;
 clFioletowy           = 13829582;
 clSzary               = 10461087;
 clBialy               = clWhite;
 clZloty               = 8647162;
 clSrebrny             = 14211288;


 tablica_kolorowRGB :array[0..11] of integer = (clCzarny,clBrazowy,clCzerwony,
                 clPomaranczowy,clZolty,clZielony,clNiebieski,clFioletowy,
                 clSzary,clBialy,clZloty,clSrebrny);

 E12 : array[0..11] of byte=(10,12,15,18,22,27,33,39,47,56,68,82);

type
  TPoprawne_kolory_pojedynczego_paska = set of byte;
  TPoprawne_kolory=array [1..4] of TPoprawne_kolory_pojedynczego_paska;

var
  poprawne_kolory:TPoprawne_kolory;


function potega(podst,wykl:integer):integer;

//Zamieniamy RGB na warto z zakresu 0-11
// RGB -> 0..11
function RGBToIndex(RGB:integer):integer;
function IndexToRGB(index:integer):integer;

//Dla zadanego koloru 0-11 lub RGB zwracamy jego nazwe
function NazwaKoloru(kolor:integer):string;
function NazwaKoloruRGB(kolorRGB:integer):string;

{----------KONWERSJE OPORNOCI-------------BEGIN}
//Wszystie z R_
//Wywolywac z kolorami 0-11 lub RGB
//function KodPaskowyToStr(a,b,c:integer):string;
//function KodPaskowyRGBToStr(RGB1,RGB2,RGB3:integer):string;
//KODPASKOWY TO INT
function R_KodPaskowyToInt( p1,p2,p3:integer):integer;
function R_KodPaskowyRGBToInt( RGB1,RGB2,RGB3:integer):integer;

//STRNG TO INT
function R_StrToInt(napis:string;var R:Integer):boolean;

//INT TO ...
procedure R_IntToKodPaskowyRGB( R:Integer;var p1,p2,p3:Integer);
function  R_IntToStr(R:integer):string;
{----------KONWERSJE OPORNOCI-------------END}



function Procenty(czyjestczwartypasek:boolean;numerkolorupaska:integer):string;
//function KolorPaska(pasek:integer;napis:string):Integer;

implementation

function potega(podst,wykl:integer):integer;
var
  x,z:integer;
begin
 x:=1;
 z:=podst;
 repeat
   if odd(wykl) then
     x:=z*x;
   z:=z*z;
   wykl:=wykl div 2;
 until wykl=0;
 potega:=x;
end;



function RGBToIndex(RGB:integer):integer;
begin
  case RGB of
    clCzarny              : RGBToIndex:=0;
    clBrazowy             : RGBToIndex:=1;
    clCzerwony            : RGBToIndex:=2;
    clPomaranczowy        : RGBToIndex:=3;
    clZolty               : RGBToIndex:=4;
    clZielony             : RGBToIndex:=5;
    clNiebieski           : RGBToIndex:=6;
    clFioletowy           : RGBToIndex:=7;
    clSzary               : RGBToIndex:=8;
    clBialy               : RGBToIndex:=9;
    clZloty               : RGBToIndex:=10;
    clSrebrny             : RGBToIndex:=11;
    else
      RGBToIndex:=-1;
  end;//case...
end;

function IndexToRGB(index:integer):integer;
begin
  if (index<12) and (index>=0) then
    IndexToRGB:=tablica_kolorowRGB[index]
  else
    IndexToRGB:=-1;
end;

function NazwaKoloru(kolor:integer):string;
begin
  case kolor of
    0             : NazwaKoloru:='Czarny';
    1             : NazwaKoloru:='Brzowy';
    2             : NazwaKoloru:='Czerwony';
    3             : NazwaKoloru:='Pomaraczowy';
    4             : NazwaKoloru:='ty';
    5             : NazwaKoloru:='Zielony';
    6             : NazwaKoloru:='Niebieski';
    7             : NazwaKoloru:='Fioletowy';
    8             : NazwaKoloru:='Szary';
    9             : NazwaKoloru:='Biay';
    10            : NazwaKoloru:='Zoty';
    11            : NazwaKoloru:='Srebrny';
    else
      NazwaKoloru:='Nieznany kolor';

  end;//case...
end;

function NazwaKoloruRGB(kolorRGB:integer):string;
begin
  NazwaKoloruRGB:=NazwaKoloru(RGBToIndex(kolorRGB));
end;

function Procenty(czyjestczwartypasek:boolean;numerkolorupaska:integer):string;
begin
  if czyjestczwartypasek then
    begin
      case numerkolorupaska of
        1:Procenty:='1';
        2:Procenty:='2';
        5:Procenty:='0,5';
        10:Procenty:='5';
        11:Procenty:='10';
      end;
    end
  else
    begin
      Procenty:='20';
    end;
end;


function R_KodPaskowyToInt( p1,p2,p3:integer):integer;
begin
  R_KodPaskowyToInt:=StrToInt(inttostr(p1)+inttostr(p2))*potega(10,p3);
end;

function R_KodPaskowyRGBToInt( RGB1,RGB2,RGB3:integer):integer;
begin
  R_KodPaskowyRGBToInt:=R_KodPaskowyToInt(
    RGBToIndex(RGB1),
    RGBToIndex(RGB2),
    RGBToIndex(RGB3));
end;

procedure R_IntToKodPaskowyRGB( R:integer; var p1,p2,p3:Integer);
begin
  p1:=  IndexToRGB(R div potega(10,Trunc(Log10(R))));
  p2:=  IndexToRGB(
          (R div potega(10,Trunc(Log10(R)-1))) mod 10
        );
  p3:=IndexToRGB(Trunc(Log10(R))-1);
end;

function R_StrToInt(napis:string;var R:Integer):boolean;
begin
  R_StrToInt:=false;

  case length(napis) of
  1: begin
       if napis[1] in ['1'..'9'] then
         begin
           R_StrToInt:=false;
//           R:=StrToInt(napis)*1000;
         end;
     end;
  2: begin
       if (napis[1] in ['1'..'9']) and
          (napis[2] in ['0'..'9']) then
         begin
           R_StrToInt:=true;
           R:=StrToInt(napis);
         end
       else if (napis[1] in ['1'..'9']) and
            (napis[2] = 'k') then
            begin
              R_StrToInt:=true;
              R:=StrToInt(napis[1])*1000;
            end
       else if (napis[1] in ['1'..'9']) and
            (napis[2] = 'M') then
            begin
              R_StrToInt:=true;
              R:=StrToInt(napis[1])*1000000;
            end
     end;
  3: begin
       if (napis[1] in ['1'..'9']) and
          (napis[2] in ['0'..'9']) and
          (napis[3] in ['0'..'9']) then
          begin // 190
            R_StrToInt:=true;
            R:=StrToInt(napis);
          end
       else if (napis[1] in ['1'..'9']) and
               (napis[2] in ['0'..'9']) and
               (napis[3]='k') then
          begin // 19k
            R_StrToInt:=true;
            R:=StrToInt(napis[1]+napis[2])*1000;
          end
       else if (napis[1] in ['1'..'9']) and
               (napis[2] in ['0'..'9']) and
               (napis[3]='M') then
          begin // 19M
            R_StrToInt:=true;
            R:=StrToInt(napis[1]+napis[2])*1000000;
          end
       else if (napis[1] in ['1'..'9']) and
               (napis[3] in ['0'..'9']) and
               (napis[2]='k') then
          begin //1k9
            R_StrToInt:=true;
            R:=StrToInt(napis[1])*1000+StrToInt(napis[3])*100;
          end
       else if (napis[1] in ['1'..'9']) and
               (napis[3] in ['0'..'9']) and
               (napis[2]='M') then
          begin //1M2
            R_StrToInt:=true;
            R:=StrToInt(napis[1])*1000000+StrToInt(napis[3])*100000;
          end;
     end;
  4: begin
       if (napis[1] in ['1'..'9']) and
          (napis[2] in ['0'..'9']) and
          (napis[3] in ['0'..'9']) and
          (napis[4] ='k') then
          begin // 190k
            R_StrToInt:=true;
            R:=StrToInt(napis[1]+napis[2]+napis[3])*1000;
          end
       else if (napis[1] in ['1'..'9']) and
               (napis[2] in ['0'..'9']) and
               (napis[3] in ['0'..'9']) and
               (napis[4] ='M') then
          begin // 190M
            R_StrToInt:=true;
            R:=StrToInt(napis[1]+napis[2]+napis[3])*1000000;
          end
     end;
//  else
//    R_StrToInt:=false;
  end;//case
end;

function R_IntToStr(R:integer):string;
var
  robstr:string;
begin
  if R<1000 then
    R_IntToStr:=IntToStr(R)
  else if (R>=1000) and (R<1000000) then
    begin
      robstr:=IntToStr(R div 1000)+'k';
      if ((R mod 1000) div 100) <>0 then
        robstr:=robstr+ inttostr(((R mod 1000) div 100));
      R_IntToStr:=robstr;
    end
  else
    begin
      robstr:=IntToStr(R div 1000000)+'M';
      if ((R mod 1000000)div 100000)<>0 then
        robstr:=robstr+ inttostr(((R mod 1000000)div 100000));
      R_IntToStr:=robstr;
    end;
end;

initialization
  poprawne_kolory[1]:=[1..9];
  poprawne_kolory[2]:=[0..9];
  poprawne_kolory[3]:=[0..7];
  poprawne_kolory[4]:=[1,2,5,10,11];
end.
