unit unitformaglowna;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Menus, StdCtrls, ComCtrls, Buttons;

type
  TFormaGlowna = class(TForm)
    PanelRezystor: TPanel;
    PopupMenuPaskow: TPopupMenu;
    MenuCzerwony: TMenuItem;
    MenuPomaranczowy: TMenuItem;
    MenuBrazowy: TMenuItem;
    PanelKolory: TPanel;
    ShapeKolor: TShape;
    ShapeCzerwony: TShape;
    ShapeCzarny: TShape;
    ShapeZielony: TShape;
    ShapeBrazowy: TShape;
    ShapeZolty: TShape;
    ShapeNiebieski: TShape;
    ShapeFioletowy: TShape;
    ShapeSzary: TShape;
    ShapePomaranczowy: TShape;
    ShapeBialy: TShape;
    ShapeZloty: TShape;
    ShapeSrebrny: TShape;
    MenuZolty: TMenuItem;
    MenuZielony: TMenuItem;
    MenuNiebieski: TMenuItem;
    MenuFioletowy: TMenuItem;
    MenuSzary: TMenuItem;
    MenuBialy: TMenuItem;
    MenuCzarny: TMenuItem;
    MenuSrebrny: TMenuItem;
    MenuZloty: TMenuItem;
    PopupMenuRezystora: TPopupMenu;
    MenuBrakczwartegopsaka: TMenuItem;
    MenuPokaczwartypasek: TMenuItem;
    PanelCzwartyPasek: TPanel;
    CheckBoxCzwartyPasek: TCheckBox;
    PanelEdycja: TPanel;
    EditRJakoString: TEdit;
    EditRJakoInteger: TEdit;
    Label4: TLabel;
    Label3: TLabel;
    ComboBoxE12: TComboBox;
    PanelWartosc: TPanel;
    LabelRezystencja: TLabel;
    LabelWartoscRezystencji: TLabel;
    LabelWartoscTolerancji: TLabel;
    LabelTolerancja: TLabel;
    PanelAlert: TPanel;
    Label1: TLabel;
    Buttonx10: TButton;
    Button_10: TButton;
    ButtonPrev: TButton;
    ButtonNext: TButton;
    TrackBar1: TTrackBar;
    LabelInfo: TLabel;
    LabelInfo2: TLabel;
    LabelInfo3: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    ImageAlert: TImage;
    BitBtn3: TBitBtn;
    pb: TPaintBox;
    LabelRezystorPodpis: TLabel;
    ShapeNozkalewa: TShape;
    ShapeRezystor: TShape;
    ShapePasek1: TShape;
    ShapePasek2: TShape;
    ShapePasek3: TShape;
    ShapePasek4: TShape;
    ShapeNozkaPrawa: TShape;
    SD: TSaveDialog;
    LOmega: TLabel;
    procedure ZmienKolorPaska(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ZmienKolorDomyslny(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure PokazUkryj4Pasek(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure CheckBoxCzwartyPasekClick(Sender: TObject);
    procedure MenuBrakczwartegopsakaClick(Sender: TObject);
    procedure MenuPokaczwartypasekClick(Sender: TObject);
    procedure ZmienKolorZMenuKontekstowego(Sender: TObject);
    procedure EditRJakoStringChange(Sender: TObject);
    procedure EditRJakoStringKeyPress(Sender: TObject; var Key: Char);
    procedure EditRJakoIntegerChange(Sender: TObject);
    procedure EditRJakoIntegerKeyPress(Sender: TObject; var Key: Char);
    procedure EditRJakoIntegerExit(Sender: TObject);
    procedure ImageAlertMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure EditRJakoStringExit(Sender: TObject);
    procedure ComboBoxE12Change(Sender: TObject);
    procedure Buttonx10Click(Sender: TObject);
    procedure Button_10Click(Sender: TObject);
    procedure ButtonNextClick(Sender: TObject);
    procedure ButtonPrevClick(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure ShapeCzarnyMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure PanelKoloryMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure pbPaint(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    R:integer;      //warto rezystencji w Omach
                    //Na podstawie tej wartoci ustalamy wygld
                    //wszystkich kontrolek

    pasek:integer; //numer wybranego paska - potrzebny do operowania popupmenu

    widocznyczwartypasek:boolean;
    kolorzmenu:integer;

    paski             :  array[1..4] of TShape;
    TablicaOpcjiMenu  :  array[0..11] of TMenuItem;

    poprzedni:string; //poprzednia zawarto edita

    bdbuf:TBitmap;    

    procedure uaktualnij_z_R;
    procedure UdostepnijOpcjeMenuPaska(pasek:byte);
    procedure UstalRNaPodstawiePaskow;
    function  OpcjaMenuKontekstowegoToIndex(opcja:TObject):integer;
    function  OpcjaMenuKontekstowegoToRGB(opcja:TObject):integer;
    Function  IndexPaska(pasek:TObject):byte;


  end;

var
  FormaGlowna: TFormaGlowna;

implementation

uses stalekolorow,CommCtrl, UnitOProgramie,jpeg;

{$R *.DFM}


procedure TFormaGlowna.ZmienKolorPaska(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbLeft then
    begin
      //Czy kolor domyslny jest dopuszczalny?
      if (RGBToIndex(ShapeKolor.Brush.Color) in
         poprawne_kolory[IndexPaska(Sender)])
      then
        begin
          (Sender as TShape).Brush.Color:=ShapeKolor.Brush.Color;
          UstalRNaPodstawiePaskow;
        end
    end
  else
    begin
      pasek:=IndexPaska(Sender);
      UdostepnijOpcjeMenuPaska(pasek);
      PopUpMenuPaskow.Popup(FormaGlowna.left+PanelRezystor.left+(sender as TShape).left+x,
                            FormaGlowna.top+PanelRezystor.top+(sender as TShape).top+y);
    end;
  uaktualnij_z_R;
end;

procedure TFormaGlowna.ZmienKolorDomyslny(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  ShapeKolor.Brush.Color:=(sender as TShape).Brush.Color;
  uaktualnij_z_R;
end;



procedure TFormaGlowna.FormCreate(Sender: TObject);
var
  rob,k,i:integer;
  robstr:string;

begin
  bdbuf:=TBitmap.Create;
  bdbuf.width:=pb.width;
  bdbuf.height:=pb.height;


  ShapeCzarny.brush.color:=clCzarny;
  ShapeBrazowy.brush.color:=clBrazowy;
  ShapeCzerwony.brush.color:=clCzerwony;
  ShapePomaranczowy.brush.color:=clPomaranczowy;
  ShapeZolty.brush.color:=clZolty;
  ShapeZielony.brush.color:=clZielony;
  ShapeNiebieski.brush.color:=clNiebieski;
  ShapeFioletowy.brush.color:=clFioletowy;
  ShapeSzary.brush.color:=clSzary;
  ShapeBialy.brush.color:=clBialy;
  ShapeZloty.brush.color:=clZloty;
  ShapeSrebrny.brush.color:=clSrebrny;

  widocznyczwartypasek:=true;

  paski[1]:=ShapePasek1;
  paski[2]:=ShapePasek2;
  paski[3]:=ShapePasek3;
  paski[4]:=ShapePasek4;

  TablicaOpcjiMenu[0]:=  MenuCzarny;
  TablicaOpcjiMenu[1]:=  MenuBrazowy;
  TablicaOpcjiMenu[2]:=  MenuCzerwony;
  TablicaOpcjiMenu[3]:=  MenuPomaranczowy;
  TablicaOpcjiMenu[4]:=  MenuZolty;
  TablicaOpcjiMenu[5]:=  MenuZielony;
  TablicaOpcjiMenu[6]:=  MenuNiebieski;
  TablicaOpcjiMenu[7]:=  MenuFioletowy;
  TablicaOpcjiMenu[8]:=  MenuSzary;
  TablicaOpcjiMenu[9]:=  MenuBialy;
  TablicaOpcjiMenu[10]:= MenuSrebrny;
  TablicaOpcjiMenu[11]:= MenuZloty;

  R:=1000;

 ComboBoxE12.Items.Add('BRAK');
  for i:=0 to 7 do
    for k:=0 to 11 do
      begin
        rob:=E12[k]*potega(10,i);
        robstr:=R_IntToStr(rob);
        ComboBoxE12.Items.Add(robstr);
      end;


  labelInfo.Caption:='';
  labelInfo2.Caption:='';
  labelInfo3.Caption:='';
  uaktualnij_z_R;


end;

procedure TFormaGlowna.PokazUkryj4Pasek(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  PopUpMenuRezystora.PopUp(FormaGlowna.left+PanelRezystor.left+ShapeRezystor.left+x,
                           FormaGlowna.top+PanelRezystor.top+ShapeRezystor.top+y);
end;

procedure TFormaGlowna.CheckBoxCzwartyPasekClick(Sender: TObject);
begin
  widocznyczwartypasek:=CheckBoxCzwartyPasek.Checked;
  uaktualnij_z_R;
end;


procedure TFormaGlowna.uaktualnij_z_R;
var
  kolor1,kolor2,kolor3,rob:Integer;
begin
//uaktualniamy kontrolki rezystencji
//Rezystencja do ustalenia jest w R
  R_IntToKodPaskowyRGB(R,kolor1,kolor2,kolor3);

  paski[1].Brush.Color:=kolor1;
  paski[2].Brush.Color:=kolor2;
  paski[3].Brush.Color:=kolor3;

  EditRJakoInteger.Text:=IntToStr(R);

  EditRJakoString.Text:=R_IntToStr(R);
  LabelWartoscRezystencji.Caption:=EditRJakoString.Text;

  rob:=ComboBoxE12.Items.IndexOf(EditRJakoString.Text);
  if rob>-1 then
    ComboBoxE12.ItemIndex:=rob
  else
    ComboBoxE12.ItemIndex:=0;

  labeltolerancja.caption:=Procenty(widocznyczwartypasek,
      RGBToIndex(paski[4].Brush.Color))+' %';

//hinty, check boxy itd

  ShapePasek4.Visible:=widocznyczwartypasek;
  CheckBoxCzwartyPasek.Checked:=widocznyczwartypasek;

  ShapePasek1.hint:=NazwaKoloruRGB(ShapePasek1.Brush.Color);
  ShapePasek2.hint:=NazwaKoloruRGB(ShapePasek2.Brush.Color);
  ShapePasek3.hint:=NazwaKoloruRGB(ShapePasek3.Brush.Color);
  ShapePasek4.hint:=NazwaKoloruRGB(ShapePasek4.Brush.Color);

  ShapeKolor.hint:=NazwaKoloruRGB(ShapeKolor.Brush.Color);


  Buttonx10.Enabled:=R <=R_MAX div 10;

  Button_10.Enabled:=R div 10 >=R_MIN;

  ButtonPrev.Enabled:=ComboBoxE12.ItemIndex>1;

  ButtonNext.Enabled:=ComboBoxE12.ItemIndex<ComboBoxE12.Items.Count-1;

  TrackBar1.Position:=ComboBoxE12.ItemIndex;
  TrackBar1.Hint:=ComboBoxE12.Text;

  LabelRezystorPodpis.Caption:='REZYSTOR   '+LabelWartoscRezystencji.Caption;
  LOmega.Left:=LabelRezystorPodpis.Left+LabelRezystorPodpis.width+10;

end;

procedure TFormaGlowna.MenuBrakczwartegopsakaClick(Sender: TObject);
begin
  widocznyczwartypasek:=false;
  uaktualnij_z_R;
end;

procedure TFormaGlowna.MenuPokaczwartypasekClick(Sender: TObject);
begin
  widocznyczwartypasek:=true;
  uaktualnij_z_R;
end;

procedure TFormaGlowna.ZmienKolorZMenuKontekstowego(Sender: TObject);
begin
  kolorzmenu:=OpcjaMenuKontekstowegoToRGB(Sender);
  paski[pasek].brush.color:=kolorzmenu;
  UstalRNaPodstawiePaskow;
  uaktualnij_z_R;
end;

procedure TFormaGlowna.EditRJakoStringChange(Sender: TObject);
begin
  if R_StrToInt(EditRJakoString.Text,R) then
    begin
      if ImageAlert.Visible then ImageAlert.Hide;
      uaktualnij_z_R;
    end
  else
    if not ImageAlert.Visible then ImageAlert.Show;
end;

procedure TFormaGlowna.EditRJakoStringKeyPress(Sender: TObject; var Key: Char);
begin
  case key of
    'm','M' : begin
                if (length(EditRJakoString.text)=4) or
                    (EditRJakoString.SelStart=0) or
                    (Pos('k',EditRJakoString.Text)<>0) or
                    (Pos('M',EditRJakoString.Text)<>0) then key:=#0
                else key:='M';
              end;
    'k','K' : begin
                if (length(EditRJakoString.text)=4) or
                   (EditRJakoString.SelStart=0) or
                   (Pos('M',EditRJakoString.Text)<>0) or
                   (Pos('k',EditRJakoString.Text)<>0) then key:=#0
                else key:='k';
              end;
    '0' :  if (EditRJakoString.SelStart=0) or
              (length(EditRJakoString.text)=4) then key:=#0;

    '1'..'9'               : if length(EditRJakoString.text)=4 then key:=#0;
    char(VK_BACK)          : ;
  else
    key:=#0;
  end;
end;

procedure TFormaGlowna.EditRJakoIntegerChange(Sender: TObject);
var
  error:boolean;
begin
  error:=false;
  try
    R:=StrToInt(EditRJakoInteger.Text);
  except
    R:=1000;
    ImageAlert.Show;
    error:=true;
  end;

  if (R=0) or (R<R_MIN) or (R>R_MAX) then
      begin
        ImageAlert.Show;
        R:=1000;
        error:=true;
      end;

  if not error then
    begin
      if ImageAlert.Visible then ImageAlert.Hide;
      uaktualnij_z_R;
    end
  else
    if not ImageAlert.Visible then ImageAlert.Show;
end;

procedure TFormaGlowna.UstalRNaPodstawiePaskow;
begin
  R:=R_KodPaskowyRGBToInt( Paski[1].Brush.Color,
                         Paski[2].Brush.Color,
                         Paski[3].Brush.Color);
end;


function TFormaGlowna.OpcjaMenuKontekstowegoToIndex(opcja:TObject):integer;
var
  i:integer;
begin
  i:=0;
  while TablicaOpcjiMenu[i]<>opcja do inc(i);
  OpcjaMenuKontekstowegoToIndex:=i
end;


function TFormaGlowna.OpcjaMenuKontekstowegoToRGB(opcja:TObject):integer;
begin
  OpcjaMenuKontekstowegoToRGB:=IndexToRGB(
     OpcjaMenuKontekstowegoToIndex(opcja));
end;

Function TFormaGlowna.IndexPaska(pasek:TObject):byte;
var
  i:integer;
begin
  i:=1;
  while pasek<>paski[i] do inc(i);
  IndexPaska:=i;
end;

procedure TFormaGlowna.UdostepnijOpcjeMenuPaska(pasek:byte);
var
  i:integer;
begin
  for i:=0 to 11 do
    TablicaOpcjiMenu[i].Enabled:=i in poprawne_kolory[pasek];
end;

procedure TFormaGlowna.EditRJakoIntegerKeyPress(Sender: TObject;
  var Key: Char);
begin
  if not (key in [Char(VK_BACK) ,'0'..'9']) then
    key:=#0;
end;

procedure TFormaGlowna.EditRJakoIntegerExit(Sender: TObject);
begin
  EditRJakoInteger.Text:=IntToStr(R);
end;

procedure TFormaGlowna.ImageAlertMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  ImageAlert.Hide;
  R:=1000;
  Uaktualnij_z_R;
end;

procedure TFormaGlowna.EditRJakoStringExit(Sender: TObject);
begin
  EditRJakoString.Text:=R_IntToStr(R);
end;

procedure TFormaGlowna.ComboBoxE12Change(Sender: TObject);
begin
  if R_StrToInt(ComboBoxE12.Text,R) then
    begin
      uaktualnij_z_R;
    end
  else
    begin
      if not ImageAlert.Visible then ImageAlert.Show; 
    end;
end;

procedure TFormaGlowna.Buttonx10Click(Sender: TObject);
begin
  R:=R*10;
  Uaktualnij_z_R;
end;

procedure TFormaGlowna.Button_10Click(Sender: TObject);
begin
  R:=R div 10;
  Uaktualnij_z_R;
end;

procedure TFormaGlowna.ButtonNextClick(Sender: TObject);
begin
  if ComboBoxE12.ItemIndex<ComboBoxE12.Items.Count then
    begin
      ComboBoxE12.ItemIndex:=ComboBoxE12.ItemIndex+1;
      R_StrToInt(ComboBoxE12.Text,R);
      uaktualnij_z_R;
    end;
end;

procedure TFormaGlowna.ButtonPrevClick(Sender: TObject);
begin
  if ComboBoxE12.ItemIndex>0 then
    begin
      ComboBoxE12.ItemIndex:=ComboBoxE12.ItemIndex-1;
      R_StrToInt(ComboBoxE12.Text,R);
      uaktualnij_z_R;
    end;
end;

procedure TFormaGlowna.TrackBar1Change(Sender: TObject);
begin
  ComboBoxE12.ItemIndex:=TrackBar1.Position;
  R_StrToInt(ComboBoxE12.text,R);
  Uaktualnij_z_R;
end;

procedure TFormaGlowna.ShapeCzarnyMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var
  rob:integer;
begin
  rob:=RGBToIndex((sender as TShape).Brush.Color);

  if rob in poprawne_kolory[2] then
    LabelInfo.Caption:=IntToStr(rob)
  else
    LabelInfo.Caption:='';

  if rob in  poprawne_kolory[3] then
      LabelInfo2.Caption:=R_IntToSTR(potega(10,rob+1))+
                        ' - '+R_IntToSTR(potega(10,rob+2))
  else
    LabelInfo2.Caption:='';

  if rob in poprawne_kolory[4] then
    LabelInfo3.Caption:=Procenty(true,rob)+'%'
  else
    LabelInfo3.Caption:='';

end;

procedure TFormaGlowna.PanelKoloryMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  LabelInfo.Caption:='';
  LabelInfo2.Caption:='';
  LabelInfo3.Caption:='';
end;

procedure TFormaGlowna.BitBtn1Click(Sender: TObject);
begin
  FormaOProgramie.left:=PanelRezystor.Left+FormaGlowna.Left+3;
  FormaOProgramie.width:=PanelRezystor.width;
  FormaOProgramie.top:=PanelRezystor.top+FormaGlowna.top+22;
  FormaOProgramie.height:=PanelRezystor.height;
  FormaOProgramie.ShowModal;
end;


procedure TFormaGlowna.BitBtn3Click(Sender: TObject);
var
  mojabitmapa:TBitmap;
  j:TJPEGImage;
begin
  SD.FileName:=LabelWartoscRezystencji.Caption;
  if SD.Execute then
    begin


      mojabitmapa:=TBitmap.Create;
      mojabitmapa.width:=PB.width-6;
      mojabitmapa.height:=PB.Height-6;
      mojabitmapa.canvas.CopyRect( Rect(0,0,mojabitmapa.width,mojabitmapa.width),
                                   PB.Canvas,
                                   Rect(3,3,pb.width-3,pb.width-3));


      mojabitmapa.SaveToFile(SD.filename);
      j:=TJPEGImage.Create;
      j.assign(mojabitmapa);
      j.savetofile(ChangeFileExt(SD.filename,'.jpg'));
      j.free;
      mojabitmapa.free;
    end;
end;



procedure TFormaGlowna.pbPaint(Sender: TObject);
begin
  PB.Canvas.Pen.color:=clWhite;
  PB.Canvas.Brush.color:=clWhite;
  PB.Canvas.CopyRect(Rect(0,0,PB.Width,PB.Height),bdbuf.canvas,Rect(0,0,PB.Width,PB.Height));
end;


end.
