/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import java.util.Enumeration;
import rene.zirkel.Zirkel;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.DepList;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.ExpressionText;
import rene.zirkel.expression.ObjectExpression;
import rene.zirkel.expression.TopExpression;
import rene.zirkel.objects.ConstructionObject;

public class Expression {
    String S;
    BasicExpression E;
    boolean Valid;
    String ErrorText;
    DepList DL;
    double Value;
    boolean HasDoubleValue = false;
    boolean ForcePlus = false;

    public Expression(String s, Construction c2, ConstructionObject o, String[] var, boolean nocircles) {
        if (s.startsWith("+")) {
            this.ForcePlus = true;
            s = s.substring(1);
        }
        this.S = s;
        this.DL = new DepList();
        try {
            ExpressionText t = new ExpressionText(s, c2, o, this.DL, nocircles);
            t.setVar(var);
            this.E = TopExpression.scan(t);
            if (t.next() != '\u0000') {
                throw new ConstructionException(Zirkel.name("exception.superfluous"));
            }
            this.Valid = true;
        }
        catch (Exception e2) {
            this.Valid = false;
            this.ErrorText = e2.toString();
        }
    }

    public Expression(String s, Construction c2, ConstructionObject o, String[] var) {
        this(s, c2, o, var, false);
    }

    public Expression(String s, Construction c2, ConstructionObject o) {
        this(s, c2, o, null, false);
    }

    public boolean isValid() {
        return this.Valid;
    }

    public String getErrorText() {
        return this.ErrorText;
    }

    public double getValue() throws ConstructionException {
        if (this.HasDoubleValue) {
            return this.Value;
        }
        if (!this.Valid) {
            throw new ConstructionException(Zirkel.name("exception.expression"));
        }
        double x = this.E.getValue();
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            throw new ConstructionException(Zirkel.name("exception.value"));
        }
        return x;
    }

    public void setValue(double x) {
        this.HasDoubleValue = true;
        this.ForcePlus = false;
        this.DL = new DepList();
        this.Value = x;
    }

    public String toString() {
        if (this.HasDoubleValue) {
            return "" + this.Value;
        }
        if (this.Valid) {
            return this.E.toString();
        }
        return this.S;
    }

    public DepList getDepList() {
        return this.DL;
    }

    public void translate() {
        this.E.translate();
        this.DL.translate();
    }

    public boolean isNumber() {
        return this.HasDoubleValue || this.E.isNumber();
    }

    public void reset() {
        if (this.E != null && this.Valid) {
            this.E.reset();
        }
    }

    public boolean isForcePlus() {
        return this.ForcePlus;
    }

    public void setForcePlus(boolean flag) {
        this.ForcePlus = flag;
    }

    public ConstructionObject getObject() {
        if (this.E instanceof ObjectExpression) {
            return ((ObjectExpression)this.E).getObject();
        }
        return null;
    }

    public void addDep(ConstructionObject o) {
        Enumeration e2 = this.getDepList().elements();
        while (e2.hasMoreElements()) {
            ConstructionObject.DL.add((ConstructionObject)e2.nextElement());
        }
    }
}

