/*
 * Decompiled with CFR 0.152.
 */
package rene.util.mail;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import rene.util.mail.MailMessage;
import rene.util.mail.POPException;

public class POP {
    BufferedReader In;
    PrintWriter Out;
    Socket S;
    String Server;
    int Port;
    String Answer;
    int TotalSize;

    public POP(String server, int port) {
        this.Server = server;
        this.Port = port;
    }

    public POP(String server) {
        this(server, 110);
    }

    public void open() throws IOException {
        this.S = new Socket(this.Server, this.Port);
        this.In = new BufferedReader(new InputStreamReader(new DataInputStream(this.S.getInputStream())));
        this.Out = new PrintWriter(this.S.getOutputStream());
        if (!this.expectAnswer()) {
            throw new IOException("Could not connect!");
        }
    }

    public void close() throws IOException {
        this.In.close();
        this.Out.close();
    }

    public boolean login(String user, String password) throws IOException {
        this.send("USER " + user);
        if (!this.expectAnswer()) {
            return false;
        }
        this.send("PASS " + password);
        return this.expectAnswer();
    }

    public int getNumberOfMessages() throws IOException, POPException {
        int n;
        this.send("STAT");
        if (!this.expectAnswer()) {
            throw new POPException("status");
        }
        StringTokenizer s = new StringTokenizer(this.Answer, " ");
        if (!s.hasMoreTokens()) {
            throw new POPException("status");
        }
        try {
            n = Integer.parseInt(s.nextToken());
        }
        catch (Exception e2) {
            throw new POPException("status");
        }
        if (!s.hasMoreTokens()) {
            throw new POPException("status");
        }
        try {
            this.TotalSize = Integer.parseInt(s.nextToken());
        }
        catch (Exception e3) {
            throw new POPException("status");
        }
        return n;
    }

    public MailMessage getMessageHeader(int i) throws IOException, POPException {
        this.send("TOP " + i + " " + 0);
        if (!this.expectAnswer()) {
            this.send("RETR " + i);
            if (!this.expectAnswer()) {
                throw new POPException("retr");
            }
        }
        return this.getMessageText();
    }

    MailMessage getMessageText() throws IOException, POPException {
        MailMessage m = new MailMessage();
        while (true) {
            String s;
            if ((s = this.In.readLine()) == null) {
                throw new POPException("retr");
            }
            if (s.equals(".")) break;
            m.addLine(s);
        }
        return m;
    }

    boolean expectAnswer() throws IOException {
        String s;
        do {
            if ((s = this.In.readLine()) == null) {
                throw new IOException("Connection closed");
            }
            if (!s.startsWith("+OK")) continue;
            this.Answer = this.stripAnswer(s, 3);
            return true;
        } while (!s.startsWith("-ERR"));
        this.Answer = this.stripAnswer(s, 4);
        return false;
    }

    public void send(String s) throws IOException {
        this.Out.println(s);
        this.Out.flush();
    }

    public String stripAnswer(String s, int pos) {
        return s.substring(pos).trim();
    }

    public int getTotalSize() {
        return this.TotalSize;
    }

    public String getAnswer() {
        return this.Answer;
    }

    public void saveUIDL(Hashtable h) throws POPException, IOException {
        this.send("UIDL");
        if (!this.expectAnswer()) {
            throw new POPException("uidl");
        }
        MailMessage m = this.getMessageText();
        Enumeration e2 = m.getMessage();
        while (e2.hasMoreElements()) {
            String s = (String)e2.nextElement();
            int i = s.indexOf(32);
            if (i < 0) continue;
            h.put(s.substring(i).trim(), s);
        }
    }

    public int[] getNewMessages(Hashtable h) throws POPException, IOException {
        int i;
        this.send("UIDL");
        if (!this.expectAnswer()) {
            throw new POPException("uidl");
        }
        MailMessage m = this.getMessageText();
        Enumeration e2 = m.getMessage();
        Vector<Integer> V = new Vector<Integer>();
        while (e2.hasMoreElements()) {
            int id;
            String s = (String)e2.nextElement();
            if (h.get(s.substring(i = s.indexOf(32)).trim()) != null) continue;
            try {
                id = Integer.parseInt(s.substring(0, i));
            }
            catch (Exception ex) {
                throw new POPException("uidl");
            }
            V.addElement(new Integer(id));
        }
        int[] ids = new int[V.size()];
        i = 0;
        while (i < V.size()) {
            ids[i] = (Integer)V.elementAt(i);
            ++i;
        }
        return ids;
    }

    public static void main(String[] args) {
        try {
            POP pop = new POP(args[0]);
            pop.open();
            pop.login(args[1], args[2]);
            int n = pop.getNumberOfMessages();
            System.out.println(String.valueOf(n) + " Messages!");
            Hashtable h = new Hashtable();
            pop.saveUIDL(h);
            h = new Hashtable();
            int[] ids = pop.getNewMessages(h);
            int i = 0;
            while (i < ids.length) {
                System.out.println("----- New Message :");
                MailMessage m = pop.getMessageHeader(ids[i]);
                if (m != null) {
                    System.out.println("Last Message:");
                    System.out.println(String.valueOf(m.from()) + ", " + m.date());
                    System.out.println(m.subject());
                }
                ++i;
            }
            pop.close();
        }
        catch (Exception e2) {
            System.out.println(e2);
        }
    }
}

