/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.tools.ReorderDialog;

public class ReorderTool
extends ObjectConstructor {
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        double x = zc.x(e2.getX());
        double y = zc.y(e2.getY());
        ConstructionObject o = zc.selectObject(e2.getX(), e2.getY());
        if (o == null) {
            return;
        }
        ReorderDialog d2 = new ReorderDialog(zc, o);
        if (!d2.isAborted()) {
            String name = d2.getResult();
            if (!name.equals("")) {
                ConstructionObject u = zc.getConstruction().find(name);
                if (u == null) {
                    zc.warning(Zirkel.name("reorder.notfound"));
                    return;
                }
                if (!zc.getConstruction().reorder(o, u)) {
                    zc.warning(Zirkel.name("reorder.warning"));
                }
            } else if (!zc.getConstruction().reorder(o, null)) {
                zc.warning(Zirkel.name("reorder.warning"));
            }
        }
        zc.repaint();
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        zc.indicateObjects(e2.getX(), e2.getY());
    }

    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(Zirkel.name("message.reorder", "Reorder: Select an object!"));
    }

    public boolean useSmartBoard() {
        return false;
    }
}

