/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import rene.util.xml.XmlWriter;
import rene.zirkel.construction.Construction;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.structures.Coordinates;

public class CircleIntersectionObject
extends IntersectionObject {
    public CircleIntersectionObject(Construction c2, PrimitiveCircleObject P1, PrimitiveCircleObject P2, boolean first) {
        super(c2, P1, P2);
        this.First = first;
        this.validate();
    }

    public void updateCircleDep() {
        ((PrimitiveCircleObject)this.P1).addDep(this);
        ((PrimitiveCircleObject)this.P2).addDep(this);
    }

    public void validate() {
        boolean oldvalid = this.Valid;
        this.Valid = this.P1.valid() && this.P2.valid();
        if (!this.Valid) {
            return;
        }
        Coordinates c2 = PrimitiveCircleObject.intersect((PrimitiveCircleObject)this.P1, (PrimitiveCircleObject)this.P2);
        if (c2 == null) {
            if (oldvalid && this.getConstruction().shouldSwitch()) {
                this.doSwitch();
                if (!this.getConstruction().noteSwitch()) {
                    this.Switched = false;
                }
            } else if (oldvalid && this.Alternate && this.Away == null && this.getConstruction().canAlternate()) {
                this.First = !this.First;
            }
            this.Valid = false;
            return;
        }
        PointObject oa = this.getAway();
        if (oa != null) {
            double r1;
            boolean flag;
            double y;
            double x = oa.getX();
            double r = (x - c2.X) * (x - c2.X) + ((y = oa.getY()) - c2.Y) * (y - c2.Y);
            boolean bl = flag = r > (r1 = (x - c2.X1) * (x - c2.X1) + (y - c2.Y1) * (y - c2.Y1));
            if (!this.StayAway) {
                boolean bl2 = flag = !flag;
            }
            if (flag) {
                this.X = c2.X;
                this.Y = c2.Y;
            } else {
                this.X = c2.X1;
                this.Y = c2.Y1;
            }
        } else if (this.First) {
            this.X = c2.X;
            this.Y = c2.Y;
        } else {
            this.X = c2.X1;
            this.Y = c2.Y1;
        }
        if (this.Restricted) {
            if (((PrimitiveCircleObject)this.P1).getStart() != this && ((PrimitiveCircleObject)this.P1).getEnd() != this && !((PrimitiveCircleObject)this.P1).contains(this.X, this.Y)) {
                this.Valid = false;
            }
            if (((PrimitiveCircleObject)this.P2).getStart() != this && ((PrimitiveCircleObject)this.P2).getEnd() != this && !((PrimitiveCircleObject)this.P2).contains(this.X, this.Y)) {
                this.Valid = false;
            }
        }
    }

    public void printArgs(XmlWriter xml) {
        super.printArgs(xml);
        if (this.First) {
            xml.printArg("which", "first");
        } else {
            xml.printArg("which", "second");
        }
    }

    public boolean isSwitchable() {
        return true;
    }

    public boolean canAlternate() {
        return true;
    }
}

