/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.util.Enumeration;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class TwoPointLineObject
extends PrimitiveLineObject
implements MoveableObject {
    protected PointObject P2;
    double X2;
    double Y2;
    double R;
    double x1;
    double y1;
    double x2;
    double y2;
    double x3;
    double y3;

    public TwoPointLineObject(Construction c2, PointObject p1, PointObject p2) {
        super(c2);
        this.P1 = p1;
        this.P2 = p2;
    }

    public PointObject getP2() {
        return this.P2;
    }

    public Enumeration depending() {
        super.depending();
        return this.depset(this.P1, this.P2);
    }

    public double getLength() {
        return this.R;
    }

    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
        this.P2 = (PointObject)this.P2.getTranslation();
    }

    public boolean contains(PointObject p) {
        return this.P1 == p || this.P2 == p;
    }

    public Enumeration secondaryParams() {
        DL.reset();
        return this.depset(this.P1, this.P2);
    }

    public boolean dragTo(double x, double y) {
        this.P1.move(this.x1 + (x - this.x3), this.y1 + (y - this.y3));
        this.P2.move(this.x2 + (x - this.x3), this.y2 + (y - this.y3));
        return true;
    }

    public void move(double x, double y) {
    }

    public boolean moveable() {
        return this.P1.moveable() && this.P2.moveable();
    }

    public boolean startDrag(double x, double y) {
        this.x1 = this.P1.getX();
        this.y1 = this.P1.getY();
        this.x2 = this.P2.getX();
        this.y2 = this.P2.getY();
        this.x3 = x;
        this.y3 = y;
        return true;
    }

    public void snap(ZirkelCanvas zc) {
        if (this.moveable()) {
            this.P1.snap(zc);
            this.P2.snap(zc);
        }
    }
}

