/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import java.util.Enumeration;
import rene.util.MyVector;
import rene.zirkel.expression.EquationExpressionString;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.NameExpressionString;
import rene.zirkel.objects.ConstructionObject;

public class ExpressionString {
    MyVector v = new MyVector(3);
    ConstructionObject O;

    public ExpressionString(String s, ConstructionObject o) {
        int n;
        this.O = o;
        this.v.removeAllElements();
        int h1 = 0;
        while ((n = s.indexOf("%", h1)) >= 0) {
            int h2 = s.indexOf("%", n + 1);
            if (h2 == n + 1) {
                this.v.addElement(s.substring(h1, n));
                this.v.addElement("%");
                h1 = n + 2;
                continue;
            }
            if (h2 >= 0) {
                String name;
                this.v.addElement(s.substring(h1, n));
                if (s.charAt(n + 1) == '~') {
                    name = s.substring(n + 2, h2);
                    this.v.addElement(new EquationExpressionString(new Expression(s.substring(n + 2, h2), this.O.getConstruction(), this.O)));
                    h1 = h2 + 1;
                    continue;
                }
                if (s.charAt(n + 1) == '=') {
                    name = s.substring(n + 2, h2);
                    this.v.addElement(new NameExpressionString(new Expression(s.substring(n + 2, h2), this.O.getConstruction(), this.O)));
                    h1 = h2 + 1;
                    continue;
                }
                Expression ex = new Expression(s.substring(n + 1, h2), this.O.getConstruction(), this.O);
                this.v.addElement(ex);
                h1 = h2 + 1;
                continue;
            }
            this.v.addElement(s.substring(h1, n));
            this.v.addElement("%");
            h1 = n + 1;
        }
        if (!s.equals("")) {
            this.v.addElement(s.substring(h1));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration e2 = this.v.elements();
        while (e2.hasMoreElements()) {
            Object o = e2.nextElement();
            if (o instanceof String) {
                if (((String)o).equals("%")) {
                    sb.append("%%");
                    continue;
                }
                sb.append((String)o);
                continue;
            }
            if (o instanceof Expression) {
                sb.append("%");
                if (((Expression)o).isForcePlus()) {
                    sb.append("+");
                }
                sb.append(o.toString());
                sb.append("%");
                continue;
            }
            if (o instanceof EquationExpressionString) {
                sb.append("%~");
                sb.append(((EquationExpressionString)o).toString());
                sb.append("%");
                continue;
            }
            if (!(o instanceof NameExpressionString)) continue;
            sb.append("%=");
            sb.append(((NameExpressionString)o).toString());
            sb.append("%");
        }
        return sb.toString();
    }

    public String evaluate() {
        StringBuffer sb = new StringBuffer();
        Enumeration e2 = this.v.elements();
        while (e2.hasMoreElements()) {
            Object o = e2.nextElement();
            if (o instanceof String) {
                if (((String)o).equals("%")) {
                    sb.append("%");
                    continue;
                }
                sb.append((String)o);
                continue;
            }
            if (o instanceof Expression) {
                try {
                    double value = ((Expression)o).getValue();
                    value = this.O.round(value);
                    if (((Expression)o).isForcePlus() && value >= 0.0) {
                        sb.append("+");
                    }
                    if (value == Math.floor(value + 0.5)) {
                        sb.append((int)value);
                        continue;
                    }
                    sb.append(this.O.round(value));
                }
                catch (Exception exc) {
                    sb.append("???");
                }
                continue;
            }
            if (o instanceof EquationExpressionString) {
                sb.append(((EquationExpressionString)o).getEquation());
                continue;
            }
            if (!(o instanceof NameExpressionString)) continue;
            sb.append(((NameExpressionString)o).getName());
        }
        return sb.toString();
    }

    public void translate() {
        Enumeration e2 = this.v.elements();
        while (e2.hasMoreElements()) {
            Object o = e2.nextElement();
            if (o instanceof Expression) {
                ((Expression)o).translate();
                continue;
            }
            if (o instanceof EquationExpressionString) {
                ((EquationExpressionString)o).translate();
                continue;
            }
            if (!(o instanceof NameExpressionString)) continue;
            ((NameExpressionString)o).translate();
        }
    }

    public void addDep(ConstructionObject oc) {
        Enumeration e2 = this.v.elements();
        while (e2.hasMoreElements()) {
            Object o = e2.nextElement();
            if (o instanceof Expression) {
                ((Expression)o).addDep(oc);
                continue;
            }
            if (o instanceof EquationExpressionString) {
                ((EquationExpressionString)o).addDep(oc);
                continue;
            }
            if (!(o instanceof NameExpressionString)) continue;
            ((NameExpressionString)o).addDep(oc);
        }
    }
}

