/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.ExpressionText;
import rene.zirkel.expression.SumExpression;

class CompareExpression
extends BasicExpression {
    BasicExpression E1;
    BasicExpression E2;
    int Operator;
    static final int LESS = 1;
    static final int LESSEQUAL = 2;
    static final int GREATER = 3;
    static final int GREATEREQUAL = 4;
    static final int EQUAL = 5;
    static final int ABOUTEQUAL = 6;

    public CompareExpression(BasicExpression e1, BasicExpression e2, int op) {
        this.E1 = e1;
        this.E2 = e2;
        this.Operator = op;
    }

    public static BasicExpression scan(ExpressionText t) throws ConstructionException {
        BasicExpression E1 = SumExpression.scan(t);
        char c2 = t.next();
        int op = 0;
        if (c2 == '<') {
            t.advance();
            if (t.next(true) == '=') {
                op = 2;
                t.advance();
            } else {
                op = 1;
            }
        } else if (c2 == '>') {
            t.advance();
            if (t.next(true) == '=') {
                op = 4;
                t.advance();
            } else {
                op = 3;
            }
        } else if (c2 == '=') {
            t.advance();
            if (t.next(true) == '=') {
                t.advance();
            }
            op = 5;
        } else if (c2 == '~') {
            t.advance();
            if (t.next(true) == '=') {
                t.advance();
            }
            op = 6;
        } else {
            return E1;
        }
        BasicExpression E2 = SumExpression.scan(t);
        return new CompareExpression(E1, E2, op);
    }

    public double getValue() throws ConstructionException {
        switch (this.Operator) {
            case 1: {
                return this.logical(this.E1.getValue() < this.E2.getValue());
            }
            case 2: {
                return this.logical(this.E1.getValue() <= this.E2.getValue());
            }
            case 3: {
                return this.logical(this.E1.getValue() > this.E2.getValue());
            }
            case 4: {
                return this.logical(this.E1.getValue() >= this.E2.getValue());
            }
            case 5: {
                return this.logical(this.E1.getValue() == this.E2.getValue());
            }
            case 6: {
                return this.logical(Math.abs(this.E1.getValue() - this.E2.getValue()) < 1.0E-10);
            }
        }
        return 0.0;
    }

    public double logical(boolean flag) {
        if (flag) {
            return 1.0;
        }
        return 0.0;
    }

    public void translate() {
        this.E1.translate();
        this.E2.translate();
    }

    public String toString() {
        switch (this.Operator) {
            case 1: {
                return this.E1 + "<" + this.E2;
            }
            case 2: {
                return this.E1 + "<=" + this.E2;
            }
            case 3: {
                return this.E1 + ">" + this.E2;
            }
            case 4: {
                return this.E1 + ">=" + this.E2;
            }
            case 5: {
                return this.E1 + "==" + this.E2;
            }
            case 6: {
                return this.E1 + "~=" + this.E2;
            }
        }
        return "";
    }

    public void reset() {
        this.E1.reset();
        this.E2.reset();
    }

    public boolean isLogical() {
        return true;
    }
}

