/*
 * Decompiled with CFR 0.152.
 */
package rene.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import rene.util.PngEncoder;

public class TestEncoder
extends Frame {
    String message;
    String timeStr;
    Image clockImage = null;
    int hour;
    int minute;
    boolean encodeAlpha;
    int filter;
    int compressionLevel;
    int pixelDepth;
    String filename;
    boolean fileSaved = false;

    public TestEncoder(String s) {
        super(s);
        this.setSize(200, 200);
    }

    public void drawClockImage(int hour, int minute) {
        Font smallFont = new Font("Helvetica", 0, 9);
        Graphics g = this.clockImage.getGraphics();
        g.setFont(smallFont);
        FontMetrics fm = g.getFontMetrics();
        if (hour < 12) {
            g.setColor(new Color(255, 255, 192));
        } else {
            g.setColor(new Color(192, 192, 255));
        }
        g.fillOval(10, 10, 80, 80);
        g.setColor(Color.black);
        g.drawOval(10, 10, 80, 80);
        g.drawOval(48, 48, 4, 4);
        g.setFont(smallFont);
        g.drawString("12", 50 - fm.stringWidth("12") / 2, 11 + fm.getAscent());
        g.drawString("3", 88 - fm.stringWidth("3"), 50 + fm.getAscent() / 2);
        g.drawString("6", 50 - fm.stringWidth("6") / 2, 88);
        g.drawString("9", 12, 50 + fm.getAscent() / 2);
        int x0 = 50;
        int y0 = 50;
        double angle = -((hour %= 12) * 30 + minute / 2) + 90;
        int x1 = (int)((double)x0 + 28.0 * Math.cos(angle *= Math.PI / 180));
        int y1 = (int)((double)y0 - 28.0 * Math.sin(angle));
        g.drawLine(x0, y0, x1, y1);
        angle = -(minute * 6) + 90;
        angle = angle * Math.PI / 180.0;
        x1 = (int)((double)x0 + 35.0 * Math.cos(angle));
        y1 = (int)((double)y0 - 35.0 * Math.sin(angle));
        g.drawLine(x0, y0, x1, y1);
    }

    public void addAlphaToImage() {
        int width = 100;
        int height = 100;
        int alphaMask = 0;
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(this.clockImage, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e2) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        int i = 0;
        while (i < width * height) {
            if (i % width == 0) {
                alphaMask = alphaMask >> 24 & 0xFF;
                if ((alphaMask += 2) > 255) {
                    alphaMask = 255;
                }
                alphaMask = alphaMask << 24 & 0xFF000000;
            }
            pixels[i] = pixels[i] & 0xFFFFFF | alphaMask;
            ++i;
        }
        this.clockImage = this.createImage(new MemoryImageSource(width, height, pixels, 0, width));
    }

    public void paint(Graphics g) {
        if (this.clockImage == null) {
            this.clockImage = this.createImage(100, 100);
        }
        if (this.clockImage != null) {
            if (!this.fileSaved) {
                this.drawClockImage(this.hour, this.minute);
                if (this.encodeAlpha) {
                    this.addAlphaToImage();
                }
                this.saveClockImage();
                this.fileSaved = true;
            }
            g.drawImage(this.clockImage, 50, 20, null);
        }
        if (this.message != null) {
            g.drawString(this.message, 10, 140);
        }
    }

    protected static void usage() {
        System.out.print("Usage: TestEncoder -alpha -filter n -compress c");
        System.out.println("-alpha means to use alpha encoding (default none)");
        System.out.println("n is filter number 0=none (default), 1=sub, 2=up");
        System.out.println("c is compression factor (0-9); 1 default");
        System.exit(0);
    }

    public static void main(String[] args) {
        TestEncoder te = new TestEncoder("Test PNG Alpha/Filter Encoder");
        int i = 0;
        te.encodeAlpha = false;
        te.filter = 0;
        te.pixelDepth = 24;
        te.compressionLevel = 1;
        while (i < args.length) {
            if (args[i].equals("-alpha")) {
                te.encodeAlpha = true;
                ++i;
                continue;
            }
            if (args[i].equals("-filter")) {
                if (i != args.length - 1) {
                    try {
                        te.filter = Integer.parseInt(args[i + 1]);
                    }
                    catch (Exception e2) {
                        TestEncoder.usage();
                        break;
                    }
                }
                i += 2;
                continue;
            }
            if (args[i].equals("-compress")) {
                if (i != args.length - 1) {
                    try {
                        te.compressionLevel = Integer.parseInt(args[i + 1]);
                    }
                    catch (Exception e3) {
                        TestEncoder.usage();
                        break;
                    }
                }
                i += 2;
                continue;
            }
            TestEncoder.usage();
            break;
        }
        if (te.pixelDepth == 8) {
            te.encodeAlpha = false;
        }
        te.doYourThing();
    }

    public void doYourThing() {
        Calendar cal = Calendar.getInstance();
        this.hour = cal.get(10);
        if (cal.get(9) == 1) {
            this.hour += 12;
        }
        this.hour %= 24;
        this.minute = cal.get(12);
        this.timeStr = Integer.toString(this.minute);
        if (this.minute < 10) {
            this.timeStr = "0" + this.timeStr;
        }
        this.timeStr = String.valueOf(Integer.toString(this.hour)) + this.timeStr;
        if (this.hour < 10) {
            this.timeStr = "0" + this.timeStr;
        }
        this.filename = this.encodeAlpha ? "alphaclock" : "clock";
        this.filename = String.valueOf(this.filename) + this.timeStr + "_f" + this.filter + this.compressionLevel + ".png";
        this.message = "File: " + this.filename;
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        };
        this.addWindowListener(l);
        this.show();
    }

    public void saveClockImage() {
        PngEncoder png = new PngEncoder(this.clockImage, this.encodeAlpha, this.filter, this.compressionLevel);
        try {
            FileOutputStream outfile = new FileOutputStream(this.filename);
            byte[] pngbytes = png.pngEncode();
            if (pngbytes == null) {
                System.out.println("Null image");
            } else {
                outfile.write(pngbytes);
            }
            outfile.flush();
            outfile.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

