/*
 * Decompiled with CFR 0.152.
 */
package rene.lister;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.PrintWriter;
import rene.gui.CloseFrame;
import rene.lister.Element;
import rene.lister.ListerPanel;
import rene.lister.StringElement;

public class Lister
extends Panel
implements AdjustmentListener {
    public ListerPanel L = new ListerPanel(this);
    Scrollbar Vertical;
    Scrollbar Horizontal;

    public Lister(boolean vs, boolean hs) {
        this.setLayout(new BorderLayout());
        this.add("Center", this.L);
        if (vs) {
            this.Vertical = new Scrollbar(1, 0, 100, 0, 1100);
            this.add("East", this.Vertical);
            this.Vertical.addAdjustmentListener(this);
        }
        if (hs) {
            this.Horizontal = new Scrollbar(0, 0, 100, 0, 1100);
            this.add("South", this.Horizontal);
            this.Horizontal.addAdjustmentListener(this);
        }
    }

    public Lister() {
        this(true, true);
    }

    public void setScrollbars(double vp, double vs, double hp, double hs) {
        if (this.Vertical != null) {
            int size = (int)(vs * 1000.0);
            int max = 1000 + size;
            int pos = (int)(vp * 1000.0);
            this.Vertical.setValues(pos, size, 0, max);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e2) {
        if (this.Vertical != null && e2.getSource() == this.Vertical) {
            switch (e2.getAdjustmentType()) {
                case 1: {
                    this.L.up(1);
                    break;
                }
                case 2: {
                    this.L.down(1);
                    break;
                }
                case 4: {
                    this.L.pageUp();
                    break;
                }
                case 3: {
                    this.L.pageDown();
                    break;
                }
                default: {
                    int size = this.Vertical.getVisibleAmount();
                    int max = this.Vertical.getMaximum();
                    int pos = this.Vertical.getValue();
                    this.L.setVerticalPos((double)pos / (double)(max - size));
                    break;
                }
            }
        } else if (this.Horizontal != null && e2.getSource() == this.Horizontal) {
            int pos = this.Horizontal.getValue();
            switch (e2.getAdjustmentType()) {
                case 1: {
                    pos += 10;
                    break;
                }
                case 2: {
                    pos -= 10;
                    break;
                }
                case 4: {
                    pos += 50;
                    break;
                }
                case 3: {
                    pos -= 50;
                }
            }
            this.L.setHorizontalPos((double)pos / 1000.0);
            this.Horizontal.setValue(pos);
        }
    }

    public ListerPanel getLister() {
        return this.L;
    }

    public void addActionListener(ActionListener al) {
        this.L.addActionListener(al);
    }

    public void updateDisplay() {
        this.L.repaint();
    }

    public void removeActionListener(ActionListener al) {
        this.L.removeActionListener(al);
    }

    public void clear() {
        this.L.clear();
    }

    public void addElement(Element el) {
        this.L.add(el);
    }

    public int getSelectedIndex() {
        if (this.L.Selected.size() > 0) {
            return (Integer)this.L.Selected.elementAt(0);
        }
        return -1;
    }

    public String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.L.getElementAt(n).getElementString();
    }

    public int[] getSelectedIndices() {
        int[] k = new int[this.L.Selected.size()];
        int i = 0;
        while (i < k.length) {
            k[i] = (Integer)this.L.Selected.elementAt(i);
            ++i;
        }
        return k;
    }

    public void showLast() {
        this.L.showLast();
    }

    public void setMode(boolean multiple, boolean easymultiple, boolean singleclick, boolean rightmouse) {
        this.L.MultipleSelection = multiple;
        this.L.EasyMultipleSelection = easymultiple;
        this.L.ReportSingleClick = singleclick;
        this.L.RightMouseClick = rightmouse;
    }

    public void save(PrintWriter o) {
        this.L.save(o);
    }

    public void select(int sel) {
    }

    public void addElement(String name, Color col) {
        this.addElement(new StringElement(name, col));
    }

    public void addElement(String name) {
        this.addElement(new StringElement(name));
    }

    public static void main(String[] args) {
        CloseFrame F = new CloseFrame("Test");
        F.setSize(300, 400);
        F.setLocation(200, 200);
        F.setLayout(new BorderLayout());
        Lister L = new Lister(true, true);
        F.add("Center", L);
        int i = 0;
        while (i < 1000) {
            L.getLister().add(new StringElement("-------------- This is line number: " + i, new Color(0, 0, i % 256)));
            ++i;
        }
        F.setVisible(true);
    }

    public void setState(int s) {
        this.L.setState(s);
    }

    public void setListingBackground(Color c2) {
        this.L.setListingBackground(c2);
    }
}

