/*
 * Decompiled with CFR 0.152.
 */
package rene.dialogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import rene.dialogs.ColorPanel;
import rene.dialogs.ColorScrollbar;
import rene.gui.ButtonAction;
import rene.gui.CloseDialog;
import rene.gui.CloseFrame;
import rene.gui.Global;
import rene.gui.MyPanel;
import rene.gui.Panel3D;

public class ColorEditor
extends CloseDialog {
    ColorScrollbar Red;
    ColorScrollbar Green;
    ColorScrollbar Blue;
    ColorScrollbar Hue;
    ColorScrollbar Saturation;
    ColorScrollbar Brightness;
    Label RedLabel;
    Label GreenLabel;
    Label BlueLabel;
    ColorPanel CP;
    String Name;
    Color Cret;
    static CloseFrame f;
    static Color cf;
    static Color[] FixedC;
    static Color[] UserC;

    static {
        cf = Color.red;
        FixedC = new Color[]{Color.white, Color.black, Color.red, Color.blue, Color.green};
        UserC = ColorPanel.getSomeColors();
    }

    public ColorEditor(Frame F, String s, Color c2, Color[] fixedc, Color[] userc) {
        super(F, Global.name("coloreditor.title"), true);
        this.Name = s;
        Color C = Global.getParameter(s, c2);
        if (C == null) {
            C = new Color(255, 255, 255);
        }
        this.CP = new ColorPanel(C, this, fixedc, userc);
        this.add("North", new Panel3D(this.CP));
        MyPanel pc = new MyPanel();
        pc.setLayout(new GridLayout(0, 1));
        MyPanel p = new MyPanel();
        p.setLayout(new GridLayout(0, 1));
        this.Hue = new ColorScrollbar(this, Global.name("coloreditor.hue"), (int)(ColorPanel.getHue(C) * 360.0), 360);
        p.add(this.Hue);
        this.Saturation = new ColorScrollbar(this, Global.name("coloreditor.saturation"), (int)(ColorPanel.getSaturation(C) * 100.0), 100);
        p.add(this.Saturation);
        this.Brightness = new ColorScrollbar(this, Global.name("coloreditor.brightness"), (int)(ColorPanel.getBrightness(C) * 100.0), 100);
        p.add(this.Brightness);
        pc.add(new Panel3D(p));
        p = new MyPanel();
        p.setLayout(new GridLayout(0, 1));
        this.Red = new ColorScrollbar(this, Global.name("coloreditor.red"), C.getRed(), 255);
        p.add(this.Red);
        this.Green = new ColorScrollbar(this, Global.name("coloreditor.green"), C.getGreen(), 255);
        p.add(this.Green);
        this.Blue = new ColorScrollbar(this, Global.name("coloreditor.blue"), C.getBlue(), 255);
        p.add(this.Blue);
        pc.add(new Panel3D(p));
        this.add("Center", new Panel3D(pc));
        MyPanel pb = new MyPanel();
        pb.add(new ButtonAction(this, Global.name("OK"), "OK"));
        pb.add(new ButtonAction(this, Global.name("abort"), "Close"));
        this.add("South", new Panel3D(pb));
        this.pack();
    }

    public ColorEditor(Frame F, String s, Color c2) {
        this(F, s, c2, null, null);
    }

    public void doAction(String o) {
        if ("OK".equals(o)) {
            Global.setParameter(this.Name, this.CP.getColor());
            this.Aborted = false;
            this.doclose();
        } else {
            super.doAction(o);
        }
    }

    public void doclose() {
        this.Cret = this.CP.getColor();
        super.doclose();
    }

    public void setcolor(ColorScrollbar cs) {
        if (cs == this.Red || cs == this.Green || cs == this.Blue) {
            Color C = new Color(this.Red.value(), this.Green.value(), this.Blue.value());
            this.CP.setNewColor(C);
            C = this.CP.getColor();
            this.Hue.set((int)(ColorPanel.getHue(C) * 360.0));
            this.Brightness.set((int)(ColorPanel.getBrightness(C) * 100.0));
            this.Saturation.set((int)(ColorPanel.getSaturation(C) * 100.0));
        } else {
            this.CP.setNewColor((double)this.Hue.value() / 180.0 * Math.PI, (double)this.Brightness.value() / 100.0, (double)this.Saturation.value() / 100.0);
            Color C = this.CP.getColor();
            this.Red.set(C.getRed());
            this.Green.set(C.getGreen());
            this.Blue.set(C.getBlue());
        }
    }

    public void setcolor(Color C) {
        this.Red.set(C.getRed());
        this.Green.set(C.getGreen());
        this.Blue.set(C.getBlue());
        this.Hue.set((int)(ColorPanel.getHue(C) * 360.0));
        this.Brightness.set((int)(ColorPanel.getBrightness(C) * 100.0));
        this.Saturation.set((int)(ColorPanel.getSaturation(C) * 100.0));
    }

    public static void main(String[] args) {
        f = new CloseFrame("Color Test"){

            public void paint(Graphics g) {
                Dimension d2 = this.getSize();
                g.setColor(cf);
                g.fillRect(0, 0, d2.width, d2.height);
            }
        };
        f.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                ColorEditor ce = new ColorEditor(f, "", cf, FixedC, UserC);
                ce.center(f);
                ce.setVisible(true);
                cf = ce.getColor();
                f.repaint();
            }
        });
        f.setSize(500, 500);
        f.center();
        f.setVisible(true);
    }

    public Color getColor() {
        return this.Cret;
    }

    public static Color[] getSomeColors() {
        return ColorPanel.getSomeColors();
    }
}

