/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import rene.gui.DoActionListener;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.MyTextField;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.ExpressionObject;

class ExpressionEditDialog
extends ObjectEditDialog
implements ItemListener {
    TextFieldAction X;
    TextFieldAction Y;
    TextField Expression;
    TextField Prompt;
    TextField Min;
    TextField Max;
    Checkbox Fixed;
    Checkbox Slider;
    Checkbox OnOff;
    ZirkelCanvas ZC;

    public ExpressionEditDialog(Frame f2, ZirkelCanvas zc, ExpressionObject o) {
        super(f2, Zirkel.name("edit.expression.title"), o, "expression");
        this.ZC = zc;
    }

    public void focusGained(FocusEvent e2) {
        this.Expression.requestFocus();
    }

    public void addFirst(Panel P) {
        ExpressionObject p = (ExpressionObject)this.O;
        this.X = new TextFieldAction((DoActionListener)this, "X", "" + p.round(p.getX()));
        P.add(new MyLabel(Zirkel.name("edit.point.x")));
        P.add(this.X);
        this.Y = new TextFieldAction((DoActionListener)this, "Y", "" + p.round(p.getY()));
        P.add(new MyLabel(Zirkel.name("edit.point.y")));
        P.add(this.Y);
        this.Fixed = new Checkbox("");
        this.Fixed.setState(p.fixed());
        P.add(new MyLabel(Zirkel.name("edit.fixed")));
        P.add(this.Fixed);
        if (p.fixed()) {
            this.X.setText(p.getEX());
            this.Y.setText(p.getEY());
        }
        this.OnOff = new Checkbox("");
        this.OnOff.setState(p.isOnOff());
        P.add(new MyLabel(Zirkel.name("edit.onoff")));
        P.add(this.OnOff);
        this.OnOff.addItemListener(this);
        MyPanel px = new MyPanel();
        px.setLayout(new GridLayout(1, 0));
        this.Slider = new Checkbox("");
        this.Slider.setState(p.isSlider());
        P.add(new MyLabel(Zirkel.name("edit.expression.slider")));
        px.add(this.Slider);
        this.Min = new TextFieldAction((DoActionListener)this, "Min", p.getMin());
        this.Max = new TextFieldAction((DoActionListener)this, "Max", p.getMax());
        px.add(this.Min);
        px.add(this.Max);
        P.add(px);
        this.Prompt = new MyTextField(p.getPrompt());
        P.add(new MyLabel(Zirkel.name("edit.expression.prompt")));
        P.add(this.Prompt);
        this.Expression = new TextFieldAction(this, "OK", p.getExpression(), 30);
        P.add(new MyLabel(Zirkel.name("edit.expression")));
        P.add(this.Expression);
    }

    public void doAction(String o) {
        if (o.equals("OK") && (this.Fixed != null && this.X.isChanged() || this.Y.isChanged())) {
            this.Fixed.setState(true);
        }
        super.doAction(o);
    }

    public void setAction() {
        double y;
        ExpressionObject p = (ExpressionObject)this.O;
        if (this.Slider.getState()) {
            p.setSlider(this.Min.getText(), this.Max.getText());
            if (this.Expression.getText().equals("")) {
                this.Expression.setText(this.Min.getText());
            }
            p.setOnOff(false);
        } else {
            p.setSlider(false);
        }
        try {
            double x = new Double(this.X.getText());
            y = new Double(this.Y.getText());
            p.move(x, y);
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            p.setExpression(this.Expression.getText(), this.ZC.getConstruction());
        }
        catch (Exception x) {
            // empty catch block
        }
        if (this.OnOff.getState()) {
            p.setOnOff(true);
            p.setSlider(false);
            try {
                p.setExpression("0.0", this.ZC.getConstruction());
            }
            catch (Exception x) {}
        } else {
            p.setOnOff(false);
        }
        if (this.Fixed.getState()) {
            p.setFixed(this.X.getText(), this.Y.getText());
        } else {
            try {
                double x = new Expression(this.X.getText(), p.getConstruction(), p).getValue();
                y = new Expression(this.Y.getText(), p.getConstruction(), p).getValue();
                p.move(x, y);
                p.setFixed(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        p.setPrompt(this.Prompt.getText());
    }

    public void itemStateChanged(ItemEvent e2) {
        if (e2.getSource() == this.OnOff) {
            if (this.OnOff.getState()) {
                this.IB.setState("showname", true);
                this.IB.setState("showvalue", false);
            } else {
                this.IB.setState("showname", false);
                this.IB.setState("showvalue", true);
            }
        }
    }
}

