/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.UserFunctionObject;

class UserFunctionExpression
extends BasicExpression {
    ConstructionObject F;
    BasicExpression[] E;
    double[] X;

    public UserFunctionExpression(ConstructionObject f2, BasicExpression[] e2) {
        this.F = f2;
        this.E = e2;
        this.X = new double[this.E.length];
    }

    public double getValue() throws ConstructionException {
        int i = 0;
        while (i < this.E.length) {
            this.X[i] = this.E[i].getValue();
            ++i;
        }
        if (this.F instanceof FunctionObject) {
            return ((FunctionObject)this.F).evaluateF(this.X);
        }
        return ((UserFunctionObject)this.F).evaluateF(this.X);
    }

    public void translate() {
        int i = 0;
        while (i < this.E.length) {
            this.E[i].translate();
            ++i;
        }
        this.F = this.F instanceof FunctionObject ? (FunctionObject)this.F.getTranslation() : (UserFunctionObject)this.F.getTranslation();
    }

    public void reset() {
        int i = 0;
        while (i < this.E.length) {
            this.E[i].reset();
            ++i;
        }
    }

    public String toString() {
        String ex = this.E[0].toString();
        int i = 1;
        while (i < this.E.length) {
            ex = String.valueOf(ex) + "," + this.E[i].toString();
            ++i;
        }
        return String.valueOf(this.F.getName()) + "(" + ex + ")";
    }
}

