/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;

public class LabelMover
extends ObjectConstructor {
    ConstructionObject P;
    ObjectConstructor OC;
    int X;
    int Y;
    double OX;
    double OY;

    public LabelMover(ObjectConstructor oc, ZirkelCanvas zc, int x, int y, ConstructionObject p, boolean shift) {
        this.OC = oc;
        this.P = p;
        if (shift || !this.P.canKeepClose()) {
            this.X = x;
            this.Y = y;
            this.P.setKeepClose(false);
            this.OX = this.P.xcOffset();
            this.OY = this.P.ycOffset();
        } else {
            this.P.setKeepClose(zc.x(x), zc.y(y));
        }
        if (this.P != null) {
            this.P.setLabelSelected(true);
            zc.repaint();
            this.showStatus(zc);
        }
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
    }

    public void mouseDragged(MouseEvent e2, ZirkelCanvas zc) {
        if (this.P == null) {
            return;
        }
        if (this.P.isKeepClose()) {
            this.P.setKeepClose(zc.x(e2.getX()), zc.y(e2.getY()));
        } else {
            this.P.setcOffset(this.OX + zc.dx(e2.getX() - this.X), this.OY + zc.dy(this.Y - e2.getY()));
        }
        zc.validate();
        zc.repaint();
    }

    public void mouseReleased(MouseEvent e2, ZirkelCanvas zc) {
        if (this.P == null) {
            return;
        }
        this.P.setLabelSelected(false);
        zc.repaint();
        this.P = null;
        this.showStatus(zc);
        zc.setTool(this.OC);
    }

    public void reset(ZirkelCanvas zc) {
        zc.clearSelected();
        this.P.setLabelSelected(false);
        zc.repaint();
    }

    public void resetPoint() {
        if (this.P != null) {
            this.P.setKeepClose(false);
            this.P.setcOffset(0.0, 0.0);
        }
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.P == null) {
            zc.showStatus(Zirkel.name("message.label.select", "Move Label: Select a label"));
        } else {
            zc.showStatus(Zirkel.name("message.label.move", "Move Label: Move the label"));
        }
    }

    public boolean useSmartBoard() {
        return false;
    }
}

