/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.TextField;
import rene.gui.ButtonAction;
import rene.gui.Global;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.MyTextField;
import rene.gui.Panel3D;
import rene.zirkel.Zirkel;
import rene.zirkel.dialogs.HelpCloseDialog;

public class SetDefaultSize
extends HelpCloseDialog {
    TextField W;
    TextField H;

    public SetDefaultSize(Frame zf, int w, int h) {
        super(zf, Global.name("defaultsize.title"), true);
        this.setLayout(new BorderLayout());
        MyPanel center = new MyPanel();
        center.setLayout(new GridLayout(0, 2));
        center.add(new MyLabel(Global.name("defaultsize.width")));
        this.W = new MyTextField("" + w);
        center.add(this.W);
        center.add(new MyLabel(Global.name("defaultsize.height")));
        this.H = new MyTextField("" + h);
        center.add(this.H);
        this.add("Center", new Panel3D(center));
        MyPanel south = new MyPanel();
        south.add(new ButtonAction(this, Zirkel.name("edit.default"), "Default"));
        south.add(new ButtonAction(this, Zirkel.name("edit.ok"), "OK"));
        south.add(new ButtonAction(this, Zirkel.name("edit.cancel"), "Close"));
        this.add("South", south);
        this.pack();
        this.center(zf);
    }

    public void doAction(String s) {
        if (s.equals("OK")) {
            this.Aborted = false;
            this.doclose();
        } else if (s.equals("Default")) {
            this.W.setText("");
            this.H.setText("");
            this.Aborted = false;
            this.doclose();
        } else {
            super.doAction(s);
        }
    }

    public int getW(int dw) {
        try {
            dw = Math.max(Math.min(Integer.parseInt(this.W.getText()), 5000), 100);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dw;
    }

    public int getH(int dh) {
        try {
            dh = Math.max(Math.min(Integer.parseInt(this.H.getText()), 5000), 100);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dh;
    }

    public boolean isDefault() {
        return this.W.getText().equals("");
    }
}

