function getNewTotals() {
  var url = "pobierzAktualneDane.php";
  url = url + "?dummy=" + new Date().getTime();
  request.open("GET", url, true);
  request.onreadystatechange = updatePage_XML;
  request.send(null);
}

function updatePage() {
  if (request.readyState == 4) {
    if (request.status == 200) {
      var newTotal = request.responseText;
      var boardsSoldEl = document.getElementById("boards-sold");
      var cashEl = document.getElementById("cash");
      replaceText(boardsSoldEl, newTotal);

      // Okrelenie zysku Kaki
      var priceEl = document.getElementById("price");
      var price = getText(priceEl);
      var costEl = document.getElementById("cost");
      var cost = getText(costEl);
      var cashPerBoard = price - cost;
      var cash = cashPerBoard * newTotal;

      // Aktualizacja kwoty wywietlonej na stronie
      cash = Math.round(cash * 100) / 100;
      replaceText(cashEl, cash);
    } else {
      var message = request.getResponseHeader("Status");
      if ((message == null) || (message.length <= 0)) {
        alert("Bd! Status dania ma warto " + request.status);
      } else {
        alert(message);
      }
    }
  }
}


function updatePage_XML() {
  if (request.readyState == 4) {
    if (request.status == 200) {
      // Pobranie aktualnych danych sprzeday z odpowiedzi XML.
      var xmlDoc = request.responseXML;
      var xmlBoards = 
            xmlDoc.getElementsByTagName("boards-sold")[0];
      var totalBoards = xmlBoards.firstChild.nodeValue;
      var xmlBoots =
            xmlDoc.getElementsByTagName("boots-sold")[0];
      var totalBoots = xmlBoots.firstChild.nodeValue;
      var xmlBindings = 
            xmlDoc.getElementsByTagName("bindings-sold")[0];
      var totalBindings = xmlBindings.firstChild.nodeValue;
      
      // Wywietlenie nowych wartoci na stronie
      var boardsSoldEl = 
            document.getElementById("deski-sprzedane");
      var bootsSoldEl = 
            document.getElementById("buty-sprzedane");
      var bindingsSoldEl = 
            document.getElementById("wiazania-sprzedane");
      var cashEl = 
            document.getElementById("kasa");
      replaceText(boardsSoldEl, totalBoards);
      replaceText(bootsSoldEl, totalBoots);
      replaceText(bindingsSoldEl, totalBindings);
      
      // Okrelenie zysku Kaki ze sprzeday desek
      var boardsPriceEl = 
            document.getElementById("deski-cena");
      var boardsPrice = getText(boardsPriceEl);
      var boardsCostEl = 
            document.getElementById("deski-koszt");
      var boardsCost = getText(boardsCostEl);
      var cashPerBoard = boardsPrice - boardsCost;
      var cash = cashPerBoard * totalBoards;
      
      // Okrelenie zysku Kaki ze sprzeday butw
      var bootsPriceEl = 
            document.getElementById("buty-cena");
      var bootsPrice = getText(bootsPriceEl);
      var bootsCostEl = document.getElementById("buty-koszt");
      var bootsCost = getText(bootsCostEl);
      var cashPerBoot = bootsPrice - bootsCost;
      var cash = cash + cashPerBoot * totalBoots;
      
      // Okrelenie zysku Kaki ze sprzeday wiza
      var bindingsPriceEl = 
            document.getElementById("wiazania-cena");
      var bindingsPrice = getText(bindingsPriceEl);
      var bindingsCostEl = 
            document.getElementById("wiazania-koszt");
      var bindingsCost = getText(bindingsCostEl);
      var cashPerBinding = bindingsPrice - bindingsCost;
      var cash = cash + cashPerBinding * totalBindings;
      
      // Aktualizacja kasy na wycigi wywietlonej na stronie
      cash = Math.round(cash * 100) / 100;
      replaceText(cashEl, cash);
    } else {
      var message = request.getResponseHeader("Status");
      if ((message == null) || (message.length <= 0)) {
        alert("Bd! Status dania ma warto " + request.status);
      } else {
        alert(message);
      }
    }
  }
}


