/**
 * Skrypt DHTML do weryfikacji poprawnoci numerw telefonicznych. 
 * Dziki uprzejmoci SmartWebby.com (http://www.smartwebby.com/dhtml/)
 */

// Deklaracje niezbdnych zmiennych
var digits = "0123456789";
// w numerach telefonicznych mona podawa jedynie cyfry
var phoneNumberDelimiters = "()- ";
// znaki dozwolone w midzynarodowych numerach telefonicznych
// (wraz ze znakiem + umieszczanym na samym pocztku)
var validWorldPhoneChars = phoneNumberDelimiters + "+";
// Minimalna ilo cyfr w midzynarodowym numerze tel.
var minDigitsInIPhoneNumber = 10;

function isInteger(s)
{   var i;
    for (i = 0; i < s.length; i++)
    {   
        // Sprawdzenie czy biecy znak jest cyfr.
        var c = s.charAt(i);
        if (((c < "0") || (c > "9"))) return false;
    }
    // Wszystkie znaki s cyframi.
    return true;
}

function stripCharsInBag(s, bag)
{   var i;
    var returnString = "";
    // Przejrzenie kolejno wszystkich znakw acucha.
    // Jeli znak jest prawidowy, zostaje on dodany do acucha returnString.
    for (i = 0; i < s.length; i++)
    {   
        // Sprawdzenie czy biecy znak nie jest odstpem.
        var c = s.charAt(i);
        if (bag.indexOf(c) == -1) returnString += c;
    }
    return returnString;
}

function checkInternationalPhone(strPhone) {
  s=stripCharsInBag(strPhone,validWorldPhoneChars); 
  return (isInteger(s) && s.length >= minDigitsInIPhoneNumber);
}

function validatePhone(phoneNumber) {
  if ((phoneNumber == null) || (phoneNumber == "")) {
    alert("Prosz poda numer telefonu.");
    return false;
  }
  if (checkInternationalPhone(phoneNumber) == false) {
    alert("Prosz poda prawidowy numer telefonu.");
    return false;
  }
  return true;
}
