package com.packtpub.hibernatesearch.domain;

import java.io.Serializable;
import java.util.Set;

/**
 * Prosta klasa encji reprezentujca sprzt elektroniczny... posiada nazw, nazw producenta, oraz kolekcj aplikacji 
 * wspieranych przez urzdzenie.
 * 
 * Ten wariant pliku Device jest mapowany do bazy danych za pomoc klasycznego podejcia opartego na plikach XML.
 * W Mavenowej strukturze projektu wszystkie pliki XML s umieszczone w "src/main/resources".  Hibernate 
 * automatycznie przeglda plik "hibernate.cfg.xml", ktry odwouje si do "com/packtpub/hibernatesearch/domain/Device.hbm.xml"
 * by zaadowa informacje o mappowaniu tej encji. Wyniki s identyczne jak w przypadku uycia adnotacji @Entity.
 * 
 * Poniewa ta klasa nie jest adnotowana za pomoc @Indexed, Hibernate Search nie utworzy dedykowanego indeksu Lucene  
 * dla niej.  Wszystkie indeksowane informacje dla tej klasy znajd si w indeksie Lucene encji zawierajcej obiekty tej klasy (np. App). 
 */
public class Device implements Serializable {

	private static final long serialVersionUID = 1L;
	
	/**
	 * Klucz gwny, skonfigurowany w pliku "Device.hbm.xml" tak, by by generowany automatycznie podczas tworzenia nowej instancji
	 * 
	 * Ta klasa encji nie ma wasnego indeksu Lucene, w zwizku z tym adnotacja @DocumentId nie jest potrzebna. 
	 */
    private Long id;
	
	/**
	 * Nazwa producenta urzdzenia. Adnotacja @Column jest zastpiona wpisem w pliku "Device.hbm.xml",
	 * ale adnotacja Hibernate Search @Field jest uywana by zmapowa wyszukiwalne pole na indeks Lucene powizanej encji (np. App).
	 */	
    private String manufacturer;
	
	/**
	 * Nazwa urzdzenia.  Adnotacja @Column jest zastpiona wpisem w pliku "Device.hbm.xml",
	 * ale adnotacja Hibernate Search @Field jest uywana by zmapowa wyszukiwalne pole na indeks Lucene powizanej encji (np. App).
	 */	
    private String name;
	
	/**
	 * Kolekcja powizanych encji typu App, reprezentujcych aplikacje wspierane przez to urzdzenie.  
	 * 
	 * Mapowanie Hibernate odbywa si w pliku "Device.hbm.xml" uywamy elementu XML "<many-to-many>"
	 * zamiast adnotacji @ManyToMany. Niemniej jednak pobieranie oraz kaskadowanie opisane w komentarzach do kodu w katalogu 
	 * "rozdzial2" maj rwnie zastosowanie w tym przypadku.
	 *
	 * Adnotacja Hibernate Search @ContainedIn jest odpowiednikiem @IndexedEmbedded (uytej dla App.SupportedDevices). 
	 * Instruuje Hibernate Search by doczyo informacje o urzdzeniach w indeksie Lucene encji App. 
	 */
	private Set<App> supportedApps;

	/**
	 * Domylny pusty konstruktor.
	 */	
	public Device() {
	}
	
	/**
	 * Wygodny konstruktor ustawiajcy wartoci wszystkich pl jednoczenie.    
	 */
	public Device(String manufacturer, String name, Set<App> supportedApps) {
		this.manufacturer = manufacturer;
		this.name = name;
		this.supportedApps = supportedApps;
	}
	
	//
	// GETTERS AND SETTERS
	//
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getManufacturer() {
		return manufacturer;
	}

	public void setManufacturer(String manufacturer) {
		this.manufacturer = manufacturer;
	}
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Set<App> getSupportedApps() {
		return supportedApps;
	}

	public void setSupportedApps(Set<App> supportedApps) {
		this.supportedApps = supportedApps;
	}

}
