<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<!--
Design by Free CSS Templates
http://www.freecsstemplates.org
Released for free under a Creative Commons Attribution 3.0 License

Name       : Unofficial Channels
Description: A two-column, fixed-width design with a bright color scheme.
Version    : 1.0
Released   : 20120723
-->
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta name="keywords" content="" />
		<meta name="description" content="" />
		<meta http-equiv="content-type" content="text/html; charset=utf-8" />
		<title>
			Bazar Aplikacji
		</title>
		<link href="http://fonts.googleapis.com/css?family=Arvo" rel="stylesheet" type="text/css" />
		<link rel="stylesheet" type="text/css" href="style.css" />
		<script language="JavaScript">

			// Ustaw aktywny kursor na okienku wyszukiwania po załadowaniu strony
			window.onload = function() {
				document.forms[0].elements["searchString"].focus();
			}
			
			// Gdy zostanie wciśnięty przycisk "Szukaj", upewnij się że pole nie jest puste i wyślij formularz
			function submitSearchForm() {
				var searchString = document.forms[0].elements["searchString"];
				if(searchString.value == null || searchString.value.replace(/^\s+|\s+$/g, '') == "") {
					alert("Musisz wpisać jakieś słowa kluczowe");
				} else {
					document.forms[0].submit();
				}
			}
		</script>
	</head>
	<body>
		<div id="bg1"></div>
		<div id="bg2"></div>
		<div id="outer">
			<div id="header">
				<div id="logo">
					<h1><a href="index.html"><i>Bazar Aplikacji</i></a></h1>
				</div>
				<form action="search" method="post">
					<div id="search">
						<div>
							<input class="text" name="searchString" size="32" maxlength="64" />
							<img src="images/search.png" style="margin: -13px;" onclick="submitSearchForm()"/>
						</div>
					</div>
				</form>
			</div>
			<div id="banner">
				<div class="captions">
					<h2><i>Największe</i>&nbsp;&nbsp;źródło aplikacji, niekoniecznie ukończonych</h2>
				</div>
				<img src="images/banner.jpg" alt="" height="150" width="1180"/>
			</div>
			<div id="main">
				<div id="sidebar">
					<div class="box">
						<h3>Nadchodzące premiery</h3>
						<div class="dateList">
							<ul class="linkedList dateList">
								<li class="first">
									<span class="date">23 lipca</span> Sfrustrowane flamingi
								</li>
								<li>
									<span class="date">28 lipca</span> Chmura!
								</li>
								<li>
									<span class="date">7 sierpnia</span> Namierzacz zszywaczy
								</li>
								<li>
									<span class="date">9 sierpnia</span> Temperówka
								</li>
							</ul>
						</div>
					</div>
				</div>
				<div id="content">
					<div class="box">
						<h2>Wyniki wyszukiwania</h2>
						
						<!-- Iteruj przez wyniki wyszukiwania umieszczone w żądaniu przez servlet, wyświetl każdy wynik w nowym wierszu. -->
						
						<table style="width: 100%; margin-left: auto; margin-right: auto;">
						<c:forEach var="app" items="${apps}">
						<tr>
							<td style="width: 25%; text-align: center; vertical-align: middle;" rowspan="2"><img src="images/apps/${app.image}"/></td>
							<td style="height: 1em; width: 75%; text-align: left; vertical-align: bottom; border-bottom: thin dotted black;"><b>${app.name}</b></td>							
						</tr>
						<tr>
							<td style="text-align: left; vertical-align: top; padding-bottom: 30px;">${app.description}</td>
						</tr>
						</c:forEach>
						</table>
					</div><br class="clear" />
				</div><br class="clear" />
			</div>
		</div>
		<div id="copyright">
			Ta aplikacja korzysta z plików HTML/CSS ze strony <a href="http://www.freecsstemplates.org/">freecsstemplates.org</a>, 
			oraz zdjęć z <a href="http://fotogrph.com/">Fotogrph</a>, obu dostępnych na licencji 
			<a href="http://creativecommons.org/licenses/by/3.0/">Creative Commons Attribution license</a>.
		</div>
	</body>
</html>
