package com.packtpub.hibernatesearch.util;

import org.hibernate.search.engine.BoostStrategy;

import com.packtpub.hibernatesearch.domain.CustomerReview;

/**
 * Klasa dynamicznie modyfikuje wag obiektu klasy CustomerReview. Obiekty CustomerReview  
 * ocenione na 5 gwiazdek maj zwikszon wano.
 */
public class FiveStarBoostStrategy implements BoostStrategy {

	public float defineBoost(Object value) {
		if(value == null || !(value instanceof CustomerReview)) {
			return 1;
		}
		CustomerReview customerReview = (CustomerReview) value;
		if(customerReview.getStars() == 5) {
			return 1.5f;
		} else {
			return 1;
		}
	}

}
