package com.packtpub.hibernatesearch.domain;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;

/**
 * Prosta klasa encji reprezentujca aplikacj komputerow ... z nazw, dugim opisem 
 * i nazw pliku uytego jako ikona.  
 * 
 * Adnotacja @Entity nakazuje Hibernate by zmapowao klas do tabeli w bazie danych, podczas gdy adnotacja @Indexed 
 * nakazuje narzdziu Hibernate Search by zmapowao j do indeksu Lucene. 
 */
@Entity
@Indexed
public class App implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * Klucz gwny, skonfigurowany tak, by by generowany automatycznie podczas tworzenia nowej instancji
	 */
 	@Id
  @GeneratedValue
  private Long id;
	
	/**
	 * Nazwa aplikacji zrozumiaa dla ludzi. Adnotacja @Column informuje Hibernate by zmapowa to pole do 
	 * kolumny w bazie danych, natomiast adnotacja @Field nazakuje Hibernate Search by zmapowa je jako pole 
	 * w indeksie Lucene.
	 */
	@Column
	@Field
  private String name;	
	
	/**
	 * Duszy, bardziej szczegowy opis aplikacji. Adnotacja @Column nazakuje Hibernateowi zmapowa to pole do 
	 * kolumny w bazie danych, natomiast adnotacja @Field nakazuje Hibernate Search by zmapowa je jako pole  
	 * indeksie Lucene.
	 */
	@Column(length=1000)
	@Field
  private String description;
	
	/**
	 * Nazwa pliku obrazka majcego by powizanym z aplikacj. Spodziewamy si, e plik bdzie istnia w podkatalogu 
	 * "images/apps/<obrazek>".  To pole nie ma adnotacji @Field, poniewa nie planujemy przeszukiwania aplikacji pod  
	 * ktem nazw plikw obrazkw.
	 */
	@Column
  private String image;
	
	/**
	 * Domylny pusty konstruktor.
	 */
	public App() {}
	
	/**
	 * Wygodny konstruktor, ustawiajcy zawarto wszystkich pl w jednym kroku.
	 */
	public App(String name, String image, String description) {
		this.name = name;
		this.image = image;
		this.description = description;
	}

	//
	// GETTERY I SETTERY
	//
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}
	
}
