/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BeatBox {
    JPanel mainPanel;
    JList incomingList;
    JTextField userMessage;
    ArrayList<JCheckBox> checkboxList;
    int nextNum;
    ObjectInputStream in;
    ObjectOutputStream out;
    Vector<String> listVector = new Vector();
    String userName;
    HashMap<String, boolean[]> otherSeqsMap = new HashMap();
    Sequencer sequencer;
    Sequence sequence;
    Sequence mySequence = null;
    Track track;
    JFrame theFrame;
    String[] instrumentNames = new String[]{"Bass Drum", "Closed Hi-Hat", "Open Hi-Hat", "Acoustic Snare", "Crash Cymbal", "Hand Clap", "High Tom", "Hi Bongo", "Maracas", "Whistle", "Low Conga", "Cowbell", "Vibraslap", "Low-mid Tom", "High Agogo", "Open Hi Conga"};
    int[] instruments = new int[]{35, 42, 46, 38, 49, 39, 50, 60, 70, 72, 64, 56, 58, 47, 67, 63};
    public static final String POKE_START_SEQUENCE = "_|SECRET_POKE_SEQUENCE|_";

    public static void main(String[] stringArray) {
        new BeatBox().startUp(stringArray[0]);
    }

    public void startUp(String string) {
        this.userName = string;
        try {
            Socket socket = new Socket("127.0.0.1", 4242);
            this.out = new ObjectOutputStream(socket.getOutputStream());
            this.in = new ObjectInputStream(socket.getInputStream());
            Thread thread = new Thread(new RemoteReader());
            thread.start();
        }
        catch (Exception exception) {
            System.out.println("Nie mo\u017cna nawi\u0105za\u0107 po\u0142\u0105czenia - musisz gra\u0107 sam.");
        }
        this.setUpMidi();
        this.buildGUI();
    }

    public void buildGUI() {
        this.theFrame = new JFrame("MuzMachina");
        this.theFrame.setDefaultCloseOperation(3);
        BorderLayout borderLayout = new BorderLayout();
        JPanel jPanel = new JPanel(borderLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.checkboxList = new ArrayList();
        Box box = new Box(1);
        JButton jButton = new JButton("Start");
        jButton.addActionListener(new MyStartListener());
        box.add(jButton);
        JButton jButton2 = new JButton("Stop");
        jButton2.addActionListener(new MyStopListener());
        box.add(jButton2);
        JButton jButton3 = new JButton("Szybciej");
        jButton3.addActionListener(new MyUpTempoListener());
        box.add(jButton3);
        JButton jButton4 = new JButton("Wolniej");
        jButton4.addActionListener(new MyDownTempoListener());
        box.add(jButton4);
        JButton jButton5 = new JButton("Wy\u015blij");
        jButton5.addActionListener(new MySendListener());
        box.add(jButton5);
        JButton jButton6 = new JButton("Wy\u015blij alarm");
        jButton6.addActionListener(new MyPokeListener());
        box.add(jButton6);
        this.userMessage = new JTextField();
        box.add(this.userMessage);
        this.incomingList = new JList();
        this.incomingList.addListSelectionListener(new MyListSelectionListener());
        this.incomingList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.incomingList);
        box.add(jScrollPane);
        this.incomingList.setListData(this.listVector);
        Box box2 = new Box(1);
        for (int i = 0; i < 16; ++i) {
            box2.add(new Label(this.instrumentNames[i]));
        }
        jPanel.add("East", box);
        jPanel.add("West", box2);
        this.theFrame.getContentPane().add(jPanel);
        GridLayout gridLayout = new GridLayout(16, 16);
        gridLayout.setVgap(1);
        gridLayout.setHgap(2);
        this.mainPanel = new JPanel(gridLayout);
        jPanel.add("Center", this.mainPanel);
        for (int i = 0; i < 256; ++i) {
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setSelected(false);
            this.checkboxList.add(jCheckBox);
            this.mainPanel.add(jCheckBox);
        }
        this.theFrame.setBounds(50, 50, 300, 300);
        this.theFrame.pack();
        this.theFrame.setVisible(true);
    }

    public void setUpMidi() {
        try {
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
            this.sequence = new Sequence(0.0f, 4);
            this.track = this.sequence.createTrack();
            this.sequencer.setTempoInBPM(120.0f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void buildTrackAndStart() {
        ArrayList<Integer> arrayList = null;
        this.sequence.deleteTrack(this.track);
        this.track = this.sequence.createTrack();
        for (int i = 0; i < 16; ++i) {
            arrayList = new ArrayList<Integer>();
            for (int j = 0; j < 16; ++j) {
                JCheckBox jCheckBox = this.checkboxList.get(j + 16 * i);
                if (jCheckBox.isSelected()) {
                    int n = this.instruments[i];
                    arrayList.add(n);
                    continue;
                }
                arrayList.add(null);
            }
            this.makeTracks(arrayList);
        }
        this.track.add(this.makeEvent(192, 9, 1, 0, 15));
        try {
            this.sequencer.setSequence(this.sequence);
            this.sequencer.setLoopCount(-1);
            this.sequencer.start();
            this.sequencer.setTempoInBPM(120.0f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void changeSequence(boolean[] blArray) {
        for (int i = 0; i < 256; ++i) {
            JCheckBox jCheckBox = this.checkboxList.get(i);
            if (blArray[i]) {
                jCheckBox.setSelected(true);
                continue;
            }
            jCheckBox.setSelected(false);
        }
    }

    public void makeTracks(ArrayList<Integer> arrayList) {
        Iterator<Integer> iterator = arrayList.iterator();
        for (int i = 0; i < 16; ++i) {
            Integer n = iterator.next();
            if (n == null) continue;
            int n2 = n;
            this.track.add(this.makeEvent(144, 9, n2, 100, i));
            this.track.add(this.makeEvent(128, 9, n2, 100, i + 1));
        }
    }

    public MidiEvent makeEvent(int n, int n2, int n3, int n4, int n5) {
        MidiEvent midiEvent = null;
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(n, n2, n3, n4);
            midiEvent = new MidiEvent(shortMessage, n5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return midiEvent;
    }

    public class RemoteReader
    implements Runnable {
        boolean[] checkboxState = null;
        String nameToShow = null;
        Object obj = null;

        @Override
        public void run() {
            try {
                while ((this.obj = BeatBox.this.in.readObject()) != null) {
                    System.out.println("Otrzymano obiekt z serwera");
                    System.out.println(this.obj.getClass());
                    String string = (String)this.obj;
                    this.checkboxState = (boolean[])BeatBox.this.in.readObject();
                    if (string.equals(BeatBox.POKE_START_SEQUENCE)) {
                        this.playPoke();
                        string = "Uwaga!";
                    }
                    BeatBox.this.otherSeqsMap.put(string, this.checkboxState);
                    BeatBox.this.listVector.add(string);
                    BeatBox.this.incomingList.setListData(BeatBox.this.listVector);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void playPoke() {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public class MyListSelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            String string;
            if (!listSelectionEvent.getValueIsAdjusting() && (string = (String)BeatBox.this.incomingList.getSelectedValue()) != null) {
                boolean[] blArray = BeatBox.this.otherSeqsMap.get(string);
                BeatBox.this.changeSequence(blArray);
                BeatBox.this.sequencer.stop();
                BeatBox.this.buildTrackAndStart();
            }
        }
    }

    public class MyPokeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean[] blArray = new boolean[255];
            try {
                BeatBox.this.out.writeObject(BeatBox.POKE_START_SEQUENCE);
                BeatBox.this.out.writeObject(blArray);
            }
            catch (Exception exception) {
                System.out.println("Nieudany alarm!");
            }
        }
    }

    public class MySendListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean[] blArray = new boolean[256];
            for (int i = 0; i < 256; ++i) {
                JCheckBox jCheckBox = BeatBox.this.checkboxList.get(i);
                if (!jCheckBox.isSelected()) continue;
                blArray[i] = true;
            }
            try {
                BeatBox.this.out.writeObject(BeatBox.this.userName + BeatBox.this.nextNum++ + ": " + BeatBox.this.userMessage.getText());
                BeatBox.this.out.writeObject(blArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Niestety, nie mo\u017cna wys\u0142a\u0107 sekwencji na serwer.");
            }
        }
    }

    public class MyDownTempoListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            float f = BeatBox.this.sequencer.getTempoFactor();
            BeatBox.this.sequencer.setTempoFactor((float)((double)f * 0.97));
        }
    }

    public class MyUpTempoListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            float f = BeatBox.this.sequencer.getTempoFactor();
            BeatBox.this.sequencer.setTempoFactor((float)((double)f * 1.03));
        }
    }

    public class MyStopListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BeatBox.this.sequencer.stop();
        }
    }

    public class MyStartListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BeatBox.this.buildTrackAndStart();
        }
    }
}

