package com.example;

import javax.servlet.http.*;
import javax.servlet.*;
import java.io.*;
import java.util.zip.GZIPOutputStream;

/**
 * To opakowanie odpowiedzi dekoruje oryginalny obiekt odpowiedzi dodajc
 * dekorator kompresji oryginalnego strumienia wyjciowego serwletu.
 */
class OpakowanieKompresjiOdpowiedzi extends HttpServletResponseWrapper {

  /** skompresowany strumie wyjciowy dla odpowiedzi serwletu */
  private GZIPServletOutputStream strumienGzipOut = null;

  /** obiekt PrintWriter dla skompresowanego strumienia wyjciowego */
  private PrintWriter pw = null;

  /**
   * Konstruktor odpowiada za logik wzorca projektowego Decorator, czyli
   * zapisanie referencji do dekorowanego obiektu (w tym przypadku do obiektu
   * odpowiedzi protokou HTTP).
   */
  OpakowanieKompresjiOdpowiedzi(HttpServletResponse odp) {
    super(odp);
  }

  //
  // Przykrywa metody interfejsu HttpServletResponse wersjami korzystajcymi
  // z naszych obiektw strumieni.
  //

  /**
   * Ta zmienna stanu reprezentuje pierwszy utworzony obiekt strumienia.
   */
  private Object uzywanyStrumien = null;

  /**
   * Zapewnia dostp do udekorowanego strumienia wyjciowego serwletu.
   */
  public ServletOutputStream getOutputStream() throws IOException {
      // Umoliwia danemu serwletowi dostp do strumienia wyjciowego serwletu
      // tylko w sytuacji, gdy ten serwlet nie ma jeszcze dostpu do obiektu
      // PrintWriter.
    if ( (uzywanyStrumien != null) && (uzywanyStrumien != strumienGzipOut) ) {
      throw new IllegalStateException();
    }
    // Opakowuje oryginalny strumie wyjciowy serwletu naszym strumieniem
    // kompresujcym. Klas tego strumienia zajmiemy si za chwil.
    if ( strumienGzipOut == null ) {
      strumienGzipOut
	  = new GZIPServletOutputStream(getResponse()
					.getOutputStream());
      uzywanyStrumien = strumienGzipOut;
    }
    return strumienGzipOut;
  }

  /**
   *  Zapewnia dostp do dekorowanego obiektu PrintWriter.
   */
  public PrintWriter getWriter() throws IOException {
    // Umoliwia danemu serwletowi dostp do strumienia wyjciowego serwletu
    // tylko w sytuacji, gdy ten serwlet nie ma jeszcze dostpu do obiektu
    // PrintWriter.
    if ( (uzywanyStrumien != null) && (uzywanyStrumien != pw) ) {
      throw new IllegalStateException();
    }
    // Stworzenie obiektu PrintWriter wymaga w pierwszej kolejnoci opakowania
    // strumienia wyjciowego serwletu. Musimy nastpnie opakowa obiekt tego
    // strumienia dwoma dodatkowymi dekoratorami strumienia wyjciowego:
    // dekoratorem OutputStreamWriter konwertujcym znaki na bajty i
    // dekoratorem PrintWriter ponad obiektem OutputStreamWriter.
    if ( pw == null ) {
      strumienGzipOut
	  = new GZIPServletOutputStream(getResponse().getOutputStream());
      // Do utworzenia obiektu OutputStreamWriter wykorzystujemy kodowanie
      // znakw odpowiedzi.
      OutputStreamWriter osw
	  = new OutputStreamWriter(servletGzipOS,
				   getResponse().getCharacterEncoding());
      // Opakowuje obiekt OutputStreamWriter w ramach obiektu PrintWriter.
      pw = new PrintWriter(osw);
      uzywanyStrumien = pw;
    }
    return pw;
  }

  /**
   * Ignoruje t metod, poniewa rzeczywiste dane wynikowe bd kompresowane.
   */
  public void setContentLength(int dl) { }

  //
  // Metody dekoratora (wykorzystywane przez nasz filtr)
  //

  /**
   * W ten sposb udostpniamy filtrowi kompresji uchwyt strumienia wyjciowego
   * GZIP, aby nasz filtr mg "zakoczy" i oprni strumie GZIP.
   */
  public GZIPOutputStream getGZIPOutputStream() {
    return this.strumienGzipOut.wewnetrznyStrumienGZIP;
  }
}


/**
 * Ta klasa pomocnicza peni funkcj dekoratora klasy abstrakcyjnej 
 * ServletOutputStream, ktra deleguje waciwe zadanie kompresji wygenerowanej
 * treci z wykorzystaniem standardowego strumienia wyjciowego GZIP.
 * 
 * Klasa strumienia wyjciowego serwletu zawiera tylko jedn metod
 * abstrakcyjn, ktra wymaga zaimplementowania przez nasz dekorator:
 * write(int). Wanie w tej metodzie znajdzie si cay kod odpowiedzialny
 * za delegowanie zada.
 */
class GZIPServletOutputStream extends ServletOutputStream {

  /**
   * Zachowuje referencj do wewntrznego strumienia wyjciowego GZIP.
   * Ta zmienna egzemplarza ma charakter prywatny na poziomie pakietu, dziki
   * czemu jest dostpna take z poziomu klasy opakowania.
   */
  GZIPOutputStream wewnetrznyStrumienGZIP;

  /** Konstruktor dekoratora */
  GZIPServletOutputStream(ServletOutputStream sos) throws IOException {
    this.wewnetrznyStrumienGZIP = new GZIPOutputStream(sos);
  }

  /**
   * Ta metoda implementuje dekorowanie kompresji przez delegowanie wywoania
   * metody write() do strumienia kompresji GZIP, ktry z kolei opakowuje
   * oryginalny strumie wyjciowy serwletu, ktry (wreszcie) opakowuje
   * strumie wyjciowy sieci TCP.
   */
  public void write(int param) throws java.io.IOException {
    wewnetrznyStrumienGZIP.write(param);
  }
}
