package com.example;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.zip.GZIPOutputStream;

/**
 * Ten filtr definiuje mechanizm kompresujcy zawarto ciaa odpowiedzi.
 * Filtry tego typu mona z powodzeniem stosowa dla dowolnych danych
 * tekstowych, w tym danych w formacie HTML, ale nie dla wikszoci danych
 * multimedialnych, jak PNG czy MPEG, ktre same w sobie s kompresowane.
 */
public class FiltrKompresujacy implements Filter {

  private ServletContext ctx;
  private FilterConfig cfg;

    /**
     * Metoda init() zapisuje obiekt konfiguracji i referencj do obiektu
     * kontekstu serwletu (na potrzeby rejestrowania zdarze w dzienniku).
     */
  public void init(FilterConfig cfg) 
	 throws ServletException {
    this.cfg = cfg;
    ctx = cfg.getServletContext();
    ctx.log(Filtr  + cfg.getFilterName() +  zosta zainicjalizowany);
  }

    /**
     * Sercem tego filtra jest mechanizm opakowujcy obiekt odpowiedzi w ramach
     * dekoratora, ktry z kolei opakowuje strumie wyjciowy w ramach
     * skompresowanego strumienia wejcia-wyjcia. Kompresja strumienia
     * wyjciowego ma miejsce tylko wtedy, gdy klient zawar w daniu
     * nagwek Accept-Encoding (z wartoci gzip).
     */
  public void doFilter(ServletRequest zad,
		       ServletResponse odp,
		       FilterChain lancuch)
	 throws IOException, ServletException {

    HttpServletRequest zadanie = (HttpServletRequest) zad;
    HttpServletResponse odpowiedz = (HttpServletResponse) odp;

    // Czy dany klient akceptuje kompresj w formacie GZIP?
    String dopuszczalne_kodowania = request.getHeader("Accept-Encoding");
    if ( (dopuszczalne_kodowania != null) && (dopuszczalne_kodowania.indexOf("gzip") > -1) ) {

      // Jeli tak, opakowuje obiekt odpowiedzi w ramach opakowania
      // kompresujcego.
      OpakowanieKompresjiOdpowiedzi opakowanieOdp
	= new OpakowanieKompresjiOdpowiedzi(odpowiedz);

      // Deklaruje tre odpowiedzi jako dane skompresowane w formacie GZIP.
      opakowanieOdp.setHeader("Content-Encoding", "gzip");

      // Dopisuje do acucha kolejny komponent (odpowiedzialny za przetworzenie
      // tego dania).
      lancuch.doFilter(zadanie, opakowanieOdp);

      // Strumie skompresowany w formacie GZIP musi by "zakoczony". Takie
      // "zakoczenie" dodatkowo powoduje oprnienie jego bufora i - tym
      // samym - wysanie wszystkich jego danych do oryginalnego strumienia
      // odpowiedzi.
      GZIPOutputStream gzos = opakowanieOdp.getGZIPOutputStream();
      gzos.finish();
      // Za pozostae zadania odpowiada kontener.

      ctx.log(cfg.getFilterName() + ": zakoczono przetwarzanie dania.");

    } else {
      lancuch.doFilter(zadanie, odpowiedz);
      ctx.log(cfg.getFilterName() + ": nie przeprowadzono kodowania odpowiedzi.");
    }
  }

  public void destroy() {
      // Przypisuje wartoci null naszym zmiennym egzemplarza.
      cfg = null;
      ctx = null;
  }
}
