<?php
  // Uruchamianie sesji.
  require_once('startsession.php');

  // Wstawianie nagłówka strony.
  $page_title = 'Kojarzenie par';
  require_once('header.php');

  require_once('appvars.php');
  require_once('connectvars.php');

  // Przed przejściem do dalszych operacji należy się upewnić, że użytkownik jest zalogowany.
  if (!isset($_SESSION['user_id'])) {
    echo '<p class="login"><a href="login.php">Zaloguj się</a>, aby uzyskać dostęp do strony.</p>';
    exit();
  }

  // Wyświetlanie menu nawigacyjnego.
  require_once('navmenu.php');

  // Łączenie się z bazą danych.
  $dbc = mysqli_connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);

  // Skrypt szuka partnera dla osób, które wypełniły już kwestionariusz.
  $query = "SELECT * FROM mismatch_response WHERE user_id = '" . $_SESSION['user_id'] . "'";
  $data = mysqli_query($dbc, $query);
  if (mysqli_num_rows($data) != 0) {
    // Najpierw należy pobrać oceny użytkownika z ich tabeli (instrukcja JOIN pozwala dołączyć nazwę tematu).
    $query = "SELECT mr.response_id, mr.topic_id, mr.response, mt.name AS topic_name " .
      "FROM mismatch_response AS mr " .
      "INNER JOIN mismatch_topic AS mt USING (topic_id) " .
      "WHERE mr.user_id = '" . $_SESSION['user_id'] . "'";
    $data = mysqli_query($dbc, $query);
    $user_responses = array();
    while ($row = mysqli_fetch_array($data)) {
      array_push($user_responses, $row);
    }

    // Inicjowanie zmiennych na wyniki wyszukiwania.
    $mismatch_score = 0;
    $mismatch_user_id = -1;
    $mismatch_topics = array();

    // Przejście w pętli po tabeli użytkowników i porównanie ich ocen z odpowiedziami aktualnie zalogowanej osoby.
    $query = "SELECT user_id FROM mismatch_user WHERE user_id != '" . $_SESSION['user_id'] . "'";
    $data = mysqli_query($dbc, $query);
    while ($row = mysqli_fetch_array($data)) {
      // Pobieranie ocen danego uytkownika (potencjalnego partnera).
      $query2 = "SELECT response_id, topic_id, response FROM mismatch_response WHERE user_id = '" . $row['user_id'] . "'";
      $data2 = mysqli_query($dbc, $query2);
      $mismatch_responses = array();
      while ($row2 = mysqli_fetch_array($data2)) {
        array_push($mismatch_responses, $row2);
      }

      // Porównanie wszystkich ocen i obliczenie poziomu niedopasowania.
      $score = 0;
      $topics = array();
      for ($i = 0; $i < count($user_responses); $i++) {
        if ($user_responses[$i]['response'] + $mismatch_responses[$i]['response'] == 3) {
          $score += 1;
          array_push($topics, $user_responses[$i]['topic_name']);
        }
      }

      // Sprawdzanie, czy dana osoba jest najbardziej niedopasowana z dotychczas ocenionych.
      if ($score > $mismatch_score) {
        // Znaleźliśmy bardziej niedopasowaną osobę, dlatego należy zaktualizować wyniki.
        $mismatch_score = $score;
        $mismatch_user_id = $row['user_id'];
        $mismatch_topics = array_slice($topics, 0);
      }
    }

    // Sprawdzanie, czy znaleziono niedopasowanego partnera.
    if ($mismatch_user_id != -1) {
      $query = "SELECT username, first_name, last_name, city, state, picture FROM mismatch_user WHERE user_id = '$mismatch_user_id'";
      $data = mysqli_query($dbc, $query);
      if (mysqli_num_rows($data) == 1) {
        // Znaleziono wiersz z danymi niedopasowanej osoby, dlatego można je wywietlić.
        $row = mysqli_fetch_array($data);
        echo '<table><tr><td class="label">';
        if (!empty($row['first_name']) && !empty($row['last_name'])) {
          echo $row['first_name'] . ' ' . $row['last_name'] . '<br />';
        }
        if (!empty($row['city']) && !empty($row['state'])) {
          echo $row['city'] . ', ' . $row['state'] . '<br />';
        }
        echo '</td><td>';
        if (!empty($row['picture'])) {
          echo '<img src="' . MM_UPLOADPATH . $row['picture'] . '" alt="Zdjcie z profilu" /><br />';
        }
        echo '</td></tr></table>';

         // Wyświetlanie tematów, z których wynika niedopasowanie.
        echo '<h4>Liczba tematów z przeciwnymi ocenami: ' . count($mismatch_topics) . 
          '. S to:</h4>';
        foreach ($mismatch_topics as $topic) {
          echo $topic . '<br />';
        }

        // Wyświetlanie odnośnika do profilu niedopasowanej osoby.
        echo '<h4>Zobacz profil użytkownika <a href=viewprofile.php?user_id=' . 
          $mismatch_user_id . '>' . $row['first_name'] . '</a>.</h4>';
      }
    }
  }
  else {
        echo '<p>Przed znalezieniem partnera musisz najpierw ' . 
          '<a href="questionnaire.php">wypełnić kwestionariusz</a>.</p>';
  }

  mysqli_close($dbc);

  // Wstawianie stopki.
  require_once('footer.php');
?>
